/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CipherSuiteManager {
    private static final List<CipherSuiteEntry> cipherSuites = CipherSuiteManager.CREATE_SUITES_COLLECTION();
    private final boolean allowCipherSuiteWithSKEM;
    private final IJVMEnvironment jvmEnvironment;

    private static List<CipherSuiteEntry> CREATE_SUITES_COLLECTION() {
        ArrayList<CipherSuiteEntry> suites = new ArrayList<CipherSuiteEntry>();
        suites.add(new CipherSuiteEntry("SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "ECDHE-ECDSA-AES(256)GCM-SHA384", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "ECDHE-ECDSA-AES(256)GCM-SHA384", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "ECDHE-RSA-AES(256)GCM-SHA384", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "ECDHE-RSA-AES(256)GCM-SHA384", true));
        suites.add(new CipherSuiteEntry("SSL_RSA_WITH_AES_256_GCM_SHA384", "RSA-RSA-AES(256)GCM-SHA384", true));
        suites.add(new CipherSuiteEntry("TLS_RSA_WITH_AES_256_GCM_SHA384", "RSA-RSA-AES(256)GCM-SHA384", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "ECDHE-ECDSA-AES(128)GCM-SHA256", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "ECDHE-ECDSA-AES(128)GCM-SHA256", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "ECDHE-RSA-AES(128)GCM-SHA256", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "ECDHE-RSA-AES(128)GCM-SHA256", true));
        suites.add(new CipherSuiteEntry("SSL_RSA_WITH_AES_128_GCM_SHA256", "RSA-RSA-AES(128)GCM-SHA256", true));
        suites.add(new CipherSuiteEntry("TLS_RSA_WITH_AES_128_GCM_SHA256", "RSA-RSA-AES(128)GCM-SHA256", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "ECDHE-ECDSA-AES(256)CBC-SHA384", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "ECDHE-ECDSA-AES(256)CBC-SHA384", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "ECDHE-RSA-AES(256)CBC-SHA384", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "ECDHE-RSA-AES(256)CBC-SHA384", true));
        suites.add(new CipherSuiteEntry("SSL_RSA_WITH_AES_256_CBC_SHA256", "RSA-RSA-AES(256)CBC-SHA256", true));
        suites.add(new CipherSuiteEntry("TLS_RSA_WITH_AES_256_CBC_SHA256", "RSA-RSA-AES(256)CBC-SHA256", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "ECDHE-ECDSA-AES(128)CBC-SHA256", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "ECDHE-ECDSA-AES(128)CBC-SHA256", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "ECDHE-RSA-AES(128)CBC-SHA256", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "ECDHE-RSA-AES(128)CBC-SHA256", true));
        suites.add(new CipherSuiteEntry("SSL_RSA_WITH_AES_128_CBC_SHA256", "RSA-RSA-AES(128)CBC-SHA256", true));
        suites.add(new CipherSuiteEntry("TLS_RSA_WITH_AES_128_CBC_SHA256", "RSA-RSA-AES(128)CBC-SHA256", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "ECDHE-ECDSA-AES(256)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "ECDHE-ECDSA-AES(256)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA", "ECDHE-RSA-AES(256)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "ECDHE-RSA-AES(256)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("SSL_RSA_WITH_AES_256_CBC_SHA", "RSA-RSA-AES(256)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("TLS_RSA_WITH_AES_256_CBC_SHA", "RSA-RSA-AES(256)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "ECDHE-ECDSA-AES(128)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "ECDHE-ECDSA-AES(128)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA", "ECDHE-RSA-AES(128)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "ECDHE-RSA-AES(128)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("SSL_RSA_WITH_AES_128_CBC_SHA", "RSA-RSA-AES(128)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("TLS_RSA_WITH_AES_128_CBC_SHA", "RSA-RSA-AES(128)CBC-SHA", true));
        suites.add(new CipherSuiteEntry("SSL_DHE_RSA_WITH_AES_256_CBC_SHA", "DH-RSA-AES(256)CBC-SHA", false));
        suites.add(new CipherSuiteEntry("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "DH-RSA-AES(256)CBC-SHA", false));
        suites.add(new CipherSuiteEntry("SSL_RSA_WITH_3DES_EDE_CBC_SHA", "RSA-RSA-DES(168)CBC3-SHA", false));
        suites.add(new CipherSuiteEntry("TLS_RSA_WITH_3DES_EDE_CBC_SHA", "RSA-RSA-DES(168)CBC3-SHA", false));
        suites.add(new CipherSuiteEntry("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "DH-RSA-DES(168)CBC3-SHA", false));
        suites.add(new CipherSuiteEntry("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "DH-RSA-DES(168)CBC3-SHA", false));
        suites.add(new CipherSuiteEntry("SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "DH-RSA-AES(128)CBC-SHA", false));
        suites.add(new CipherSuiteEntry("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "DH-RSA-AES(128)CBC-SHA", false));
        return Collections.unmodifiableList(suites);
    }

    public CipherSuiteManager(IJVMEnvironment theJvmEnvironment) throws CAMCryptoException {
        this.jvmEnvironment = theJvmEnvironment;
        this.allowCipherSuiteWithSKEM = false == this.jvmEnvironment.OnlyUseSHA_2();
    }

    private Vector<String> getSupportedCiphersuites(boolean camactive) throws CAMCryptoException {
        SSLSocketFactory sockectFactory = this.jvmEnvironment.getSSLSocketFactory();
        TreeSet<String> jvmSupportedCipherSuites = new TreeSet<String>(Arrays.asList(sockectFactory.getSupportedCipherSuites()));
        Vector<CipherSuiteEntry> cipherSuites = this.getSupportedAndEnabledCipherSuitesEntries(null, jvmSupportedCipherSuites);
        Vector<String> supportedCiphersuites = new Vector<String>(cipherSuites.size());
        TreeSet<String> seenNames = new TreeSet<String>();
        for (CipherSuiteEntry cipherSuiteEntry : cipherSuites) {
            if (cipherSuiteEntry.camactive != camactive || !seenNames.add(cipherSuiteEntry.camname)) continue;
            supportedCiphersuites.add(cipherSuiteEntry.camname);
        }
        return supportedCiphersuites;
    }

    private Vector<String> getDefaultCiphersuites() throws CAMCryptoException {
        boolean camactive = true;
        Vector<String> supportedCiphersuites = this.getSupportedCiphersuites(camactive);
        Vector<String> defaultCiphersuites = new Vector<String>();
        for (String value : supportedCiphersuites) {
            if (value.endsWith("-SHA")) continue;
            defaultCiphersuites.add(value);
        }
        return defaultCiphersuites;
    }

    private Vector<String> getDefaultCiphersuites(ArrayList<String> mergeCiphersuiteList) throws CAMCryptoException {
        Vector<String> defaultCiphersuites = new Vector<String>();
        boolean camactive = true;
        Vector<String> supportedCiphersuites = this.getSupportedCiphersuites(camactive);
        for (String ciphersuite : supportedCiphersuites) {
            if (ciphersuite.endsWith("-SHA") && !this.hasCiphersuite(mergeCiphersuiteList, ciphersuite)) continue;
            defaultCiphersuites.add(ciphersuite);
        }
        camactive = false;
        Vector<String> inactiveCiphersuites = this.getSupportedCiphersuites(camactive);
        for (String ciphersuite : inactiveCiphersuites) {
            if (!this.hasCiphersuite(mergeCiphersuiteList, ciphersuite)) continue;
            defaultCiphersuites.add(ciphersuite);
        }
        return defaultCiphersuites;
    }

    private boolean hasCiphersuite(ArrayList<String> ciphersuiteList, String ciphersuite) {
        if (ciphersuiteList == null || ciphersuite == null) {
            return false;
        }
        for (String item : ciphersuiteList) {
            if (item.compareTo(ciphersuite) != 0) continue;
            return true;
        }
        return false;
    }

    private Vector<CipherSuiteEntry> getSupportedAndEnabledCipherSuitesEntries(Set<String> enabledCipherSuites, Set<String> jvmSupportedCipherSuites) {
        int cipherSuitesSize = cipherSuites.size();
        Vector<CipherSuiteEntry> cipherSuites = new Vector<CipherSuiteEntry>(cipherSuitesSize);
        for (CipherSuiteEntry cipherSuiteEntry : CipherSuiteManager.cipherSuites) {
            String camName = cipherSuiteEntry.camname;
            String jvmName = cipherSuiteEntry.jvmname;
            if (jvmSupportedCipherSuites != null && !jvmSupportedCipherSuites.contains(jvmName) || enabledCipherSuites != null && !enabledCipherSuites.contains(camName)) continue;
            cipherSuites.add(cipherSuiteEntry);
        }
        return cipherSuites;
    }

    public Vector<String> getSupportedAndEnabledCipherSuites(Set<String> enabledCipherSuites, Set<String> jvmSupportedCipherSuites) {
        Vector<CipherSuiteEntry> cipherSuites = this.getSupportedAndEnabledCipherSuitesEntries(enabledCipherSuites, jvmSupportedCipherSuites);
        Vector<String> supportedCiphersuites = new Vector<String>(cipherSuites.size());
        for (CipherSuiteEntry cipherSuiteEntry : cipherSuites) {
            supportedCiphersuites.add(cipherSuiteEntry.jvmname);
        }
        return supportedCiphersuites;
    }

    public Element getSupportedCiphersuitesDOM(String sProviderType) throws CAMCryptoException {
        Vector<String> vCiphersuites;
        try {
            boolean camacitve = true;
            vCiphersuites = this.getSupportedCiphersuites(camacitve);
        }
        catch (Throwable e) {
            vCiphersuites = new Vector();
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("values");
        int order = 0;
        for (String value : vCiphersuites) {
            root.addElement("enum").addAttribute("value", value).addAttribute("label", value).addAttribute("order", Integer.toString(order++)).addAttribute("useLabel", new String("false"));
        }
        return document.getRootElement();
    }

    public Element getDefaultCiphersuitesDOM(String sProviderType) throws CAMCryptoException {
        Vector<String> vCiphersuites;
        try {
            vCiphersuites = this.getDefaultCiphersuites();
        }
        catch (Throwable e) {
            vCiphersuites = new Vector();
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("values");
        int order = 0;
        for (String value : vCiphersuites) {
            root.addElement("enum").addAttribute("value", value).addAttribute("label", value).addAttribute("order", Integer.toString(order++)).addAttribute("useLabel", new String("false"));
        }
        return document.getRootElement();
    }

    public Element getDefaultCiphersuitesDOM(ArrayList<String> mergeCiphersuites) throws CAMCryptoException {
        Vector<String> vCiphersuites;
        try {
            vCiphersuites = this.getDefaultCiphersuites(mergeCiphersuites);
        }
        catch (Throwable e) {
            vCiphersuites = new Vector();
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("values");
        int order = 0;
        for (String value : vCiphersuites) {
            root.addElement("enum").addAttribute("value", value).addAttribute("label", value).addAttribute("order", Integer.toString(order++)).addAttribute("useLabel", new String("false"));
        }
        return document.getRootElement();
    }

    private static final class CipherSuiteEntry {
        private final String jvmname;
        private final String camname;
        private final boolean camactive;

        private CipherSuiteEntry(String name, String camname, boolean camactive) {
            this.jvmname = name;
            this.camname = camname;
            this.camactive = camactive;
        }
    }
}

