/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SystemProtectionSession;
import com.cognos.accman.jcam.crypto.jni.JNISystemProperties;
import com.cognos.accman.jcam.crypto.misc.ActiveCMFinder;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMSSLSocketFactory;
import com.cognos.accman.jcam.crypto.misc.CipherSuiteManager;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.JSSESSLSocketFactory;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.misc.PKCS12JSSESSLSocketFactory;
import com.cognos.accman.jcam.crypto.misc.PriorityUrlList;
import com.cognos.accman.res.MessageSet;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.CCLStartupConfiguration;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.ICnfgFeedback;
import java.io.CharArrayReader;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class Configuration
implements IConfiguration {
    private static final String HMAC = "Hmac";
    private static boolean forceNoCM = false;
    private URL m_lastUrlTried = null;
    private static CAMSSLSocketFactory _socketFactory = null;
    private static CAMSSLSocketFactory _pkcs12SSLSocketFactory = null;
    private static String[] _supportedCipherSuites = null;
    static String ext = new String("/ext");
    static String EXT = new String("/EXT");
    private static Configuration singleton = null;
    private SystemProtectionSession systemProtectionSession;
    private ICCLConfiguration cclConfigObj;
    private Map configurationValues;
    private Map advancedConfigurationValues;
    private static Map signatureMapping = Configuration.staticInit();
    private static HashSet<String> FIPS_DIGEST_ALGORITHMS = new HashSet();
    private static Object cfgLock = new Object();
    private URL internalDispatcherURL;
    private URL externalDispatcherURL;
    private URL sdkURL;
    private URL gatewayURL;
    private String[] jsseCipherSuites;
    private String[] sslProtocols;
    private ICnfgFeedback m_feedback;
    boolean serverRunningCDS;
    boolean serverRunningMDM;
    boolean serverRunningTM1;
    boolean enableSecureUserCapabilitiesCache;
    boolean enableSSLHostnameVerification;
    boolean weAreIPF;
    boolean weAreCFGAPI;
    boolean weAreTheConfigurationTool;
    Boolean standaloneCA;
    Boolean disconnectContentManager;

    private static Object _sanityGetParameter(Map values, String name, Class type) throws CAMCryptoException {
        Object value = values.get(name);
        if (value == null || value.getClass() != type) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_param_missing", new String[]{name}));
        }
        return value;
    }

    public static void forceNoCM() {
        forceNoCM = true;
        Configuration.reset();
    }

    public static Configuration getInstance() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getInstanceWithConfig(String cryptoConfig) throws CAMCryptoException {
        Object object = cfgLock;
        synchronized (object) {
            Configuration cfg = new Configuration();
            cfg.parseConfig(cryptoConfig, true);
            singleton = cfg;
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IConfiguration getInstanceWithDefaultConfig(boolean isConfigTool) throws CAMCryptoException {
        Object object = cfgLock;
        synchronized (object) {
            if (singleton != null && !singleton.getWeAreCM() && isConfigTool) {
                Configuration.resetWeAreCM(isConfigTool);
            }
            if (singleton == null) {
                StringBuffer configDoc = new StringBuffer();
                int status = CCLStartupConfiguration.getStartupConfigurationDocument((StringBuffer)configDoc);
                if (status != 0 || configDoc.length() == 0) {
                    switch (status) {
                        case 1: {
                            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ccl_cfg_startup_file_not_found"));
                        }
                        case 2: {
                            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ccl_cfg_startup_file_empty"));
                        }
                        case 3: {
                            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ccl_cfg_startup_file_not_well_formed"));
                        }
                        case 4: {
                            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ccl_cfg_startup_file_bad_tags"));
                        }
                        case 5: {
                            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ccl_cfg_runtime_parse_error"));
                        }
                        case 6: {
                            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ccl_cfg_internal_error"));
                        }
                    }
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ccl_cfg_internal_error"));
                }
                Configuration cfg = new Configuration();
                cfg.parseConfig(configDoc.toString(), isConfigTool);
                singleton = cfg;
            }
            return singleton;
        }
    }

    public static String getSignatureAlgorithm(String digestAlgorithm, String signingAlgorithm) throws CAMCryptoException {
        String algorithmNameForSignature = (String)signatureMapping.get(digestAlgorithm);
        String SignatureAlgorithm = algorithmNameForSignature + "with" + signingAlgorithm;
        return SignatureAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = cfgLock;
        synchronized (object) {
            singleton = null;
        }
    }

    private static void resetWeAreCM(boolean isConfigTool) {
        Boolean cmIsEnabledParam = (Boolean)Configuration.singleton.configurationValues.get("cmIsEnabled");
        Boolean serverRunningCM = singleton.canWeCallCM(cmIsEnabledParam, isConfigTool);
        Configuration.singleton.configurationValues.put("serverRunningCM", serverRunningCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultInstance(Configuration newInstance) {
        Object object = cfgLock;
        synchronized (object) {
            singleton = newInstance;
        }
    }

    private static HashMap staticInit() {
        HashMap<String, String> tmpSignatureMapping = new HashMap<String, String>();
        tmpSignatureMapping = new HashMap();
        tmpSignatureMapping.put("MD2", "MD2");
        tmpSignatureMapping.put("MD5", "MD5");
        tmpSignatureMapping.put("SHA1", "SHA1");
        tmpSignatureMapping.put("SHA-1", "SHA1");
        tmpSignatureMapping.put("SHA224", "SHA224");
        tmpSignatureMapping.put("SHA-224", "SHA224");
        tmpSignatureMapping.put("SHA256", "SHA256");
        tmpSignatureMapping.put("SHA-256", "SHA256");
        tmpSignatureMapping.put("SHA384", "SHA384");
        tmpSignatureMapping.put("SHA-384", "SHA384");
        tmpSignatureMapping.put("SHA512", "SHA512");
        tmpSignatureMapping.put("SHA-512", "SHA512");
        return tmpSignatureMapping;
    }

    private Configuration() throws CAMCryptoException {
        FIPS_DIGEST_ALGORITHMS.add("SHA256");
        FIPS_DIGEST_ALGORITHMS.add("SHA384");
        FIPS_DIGEST_ALGORITHMS.add("SHA512");
        this.m_feedback = null;
        this.serverRunningCDS = false;
        this.serverRunningMDM = false;
        this.serverRunningTM1 = false;
        this.enableSecureUserCapabilitiesCache = true;
        this.enableSSLHostnameVerification = true;
        this.weAreIPF = false;
        this.weAreCFGAPI = false;
        this.weAreTheConfigurationTool = false;
        this.standaloneCA = null;
        this.disconnectContentManager = null;
        this.systemProtectionSession = new SystemProtectionSession();
        this.configurationValues = new HashMap();
        this.advancedConfigurationValues = new HashMap();
        this.cclConfigObj = CCLConfigurationFactory.getInstance();
    }

    @Override
    public boolean areServerConnectionsSSL() throws CAMCryptoException {
        return false;
    }

    private Boolean canWeCallCM(Boolean cmIsEnabledParam, boolean isConfigTool) {
        if (!forceNoCM && cmIsEnabledParam != null && cmIsEnabledParam.booleanValue()) {
            if (isConfigTool) {
                return Boolean.TRUE;
            }
            try {
                Class<?> cmClass = Class.forName("com.cognos.cm.store.CMCryptoDataStore");
                return Boolean.TRUE;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Boolean.FALSE;
    }

    private String[] constructJSSECipherSuitesList(boolean isConfigured) throws CAMCryptoException {
        Vector configuredCipherSuitesVector = (Vector)this.configurationValues.get("cognosCryptoCiphersuite");
        if (configuredCipherSuitesVector == null) {
            return null;
        }
        Iterator it = configuredCipherSuitesVector.iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            if (value != null) continue;
            it.remove();
        }
        TreeSet<String> configuredCipherSuites = new TreeSet<String>(configuredCipherSuitesVector);
        CipherSuiteManager cipherSuitManager = new CipherSuiteManager(JVMEnvironment.getInstance());
        TreeSet<String> jvmSupportedCipherSuites = null;
        if (isConfigured) {
            this.getCAMSSLSocketFactory();
            jvmSupportedCipherSuites = new TreeSet<String>(Arrays.asList(_supportedCipherSuites));
        }
        Vector<String> jsseCipherSuitesVec = cipherSuitManager.getSupportedAndEnabledCipherSuites(configuredCipherSuites, jvmSupportedCipherSuites);
        if (!this.useConfidentiality()) {
            jsseCipherSuitesVec.add("SSL_RSA_WITH_NULL_SHA");
            jsseCipherSuitesVec.add("SSL_RSA_WITH_NULL_MD5");
        }
        if (jsseCipherSuitesVec.size() == 0) {
            IPFTraceFunction.fatalException("Configured cipher suites list is empty.");
            return null;
        }
        return jsseCipherSuitesVec.toArray(new String[jsseCipherSuitesVec.size()]);
    }

    private URL convertCMUrlToDispatcherUrl(URL cmURL) throws CAMCryptoException {
        URL dispCmURL;
        String dispPath = cmURL.getPath() + "/dispatch";
        try {
            dispCmURL = new URL(cmURL.getProtocol(), cmURL.getHost(), cmURL.getPort(), dispPath);
        }
        catch (MalformedURLException e) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_peer_unknown"));
        }
        return dispCmURL;
    }

    @Override
    public URL getActiveCMUrl() throws CAMCryptoException {
        URL activeCmURL;
        if (!this.getWeAreTheConfigTool()) {
            URL url = null;
            try {
                String active = this.cclConfigObj.getValue("contentManager", true);
                if (active.length() != 0) {
                    url = new URL(active);
                    return url;
                }
            }
            catch (CCLConfigurationException cce) {
                throw new CAMCryptoException(cce, MessageSet.getMessage("CAM_CRP_ccl_cfg_internal_error"));
            }
            catch (MalformedURLException mue) {
                throw new CAMCryptoException(mue, "");
            }
        }
        try {
            activeCmURL = ActiveCMFinder.tryToFindActiveCM(this.getPeers());
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_remote_active_cm_req_failed"));
        }
        return activeCmURL;
    }

    @Override
    public String getAsymmKeystoreProviderName() {
        return "BC";
    }

    @Override
    public boolean getCacheCSKLocally() throws CAMCryptoException {
        if (this.getWeAreCM()) {
            return true;
        }
        return (Boolean)this.configurationValues.get("localCSK");
    }

    @Override
    public String getCAFormat() throws CAMCryptoException {
        String format = (String)this.configurationValues.get("caKeystoreType");
        return format;
    }

    @Override
    public boolean getCAIsEnabledForThisServer() throws CAMCryptoException {
        return (Boolean)this.configurationValues.get("caIsEnabledForThisServer");
    }

    @Override
    public String getCAKeyPairAlgorithm() throws CAMCryptoException {
        return this.getSigningKeyPairAlgorithm();
    }

    @Override
    public int getCAKeyPairSize() throws CAMCryptoException {
        int sz = 0;
        if (this.getSigningKeyPairAlgorithm().compareToIgnoreCase("RSA") == 0) {
            sz = JVMEnvironment.getInstance().isFIPSEnabled() ? JNISystemProperties.getFIPSKeyLength() : JNISystemProperties.getRSAKeyLength();
        } else if (this.getSigningKeyPairAlgorithm().compareToIgnoreCase("DSA") == 0) {
            sz = JNISystemProperties.getDSAKeyLength();
        } else {
            IPFTraceFunction.fatalException("Error - Configuration.getCAKeyPairSize: '" + this.getSigningKeyPairAlgorithm() + "' is not a supported Signing Key Pair algorithm.");
        }
        return sz;
    }

    @Override
    public String getCAKeyPassword() throws CAMCryptoException {
        String ksPass = (String)this.configurationValues.get("keystoreFilePassword");
        if (ksPass == null) {
            ksPass = (String)this.configurationValues.get("certificateAuthorityKeyFilePassword");
        }
        return ksPass;
    }

    @Override
    public String getCAMKeystoreLocation() throws CAMCryptoException {
        return (String)this.configurationValues.get("camKeystoreLocation");
    }

    @Override
    public synchronized CAMSSLSocketFactory getCAMSSLSocketFactory() throws CAMCryptoException {
        if (_socketFactory != null) {
            return _socketFactory;
        }
        try {
            SSLSocketFactory jsf = JVMEnvironment.getInstance().getSSLSocketFactory();
            _supportedCipherSuites = jsf.getSupportedCipherSuites();
            _socketFactory = new JSSESSLSocketFactory(jsf);
        }
        catch (CAMCryptoException c) {
            throw new CAMCryptoException(c, MessageSet.getMessage("CAM_CRP_socket_factory_create_failed"));
        }
        return _socketFactory;
    }

    @Override
    public long getCANewCertificateLifetime() throws CAMCryptoException {
        return (Long)this.configurationValues.get("certificateAuthorityServiceCertificateLifetime");
    }

    @Override
    public String getCAPassword() throws CAMCryptoException {
        return (String)this.configurationValues.get("certificateAuthorityServicePassword");
    }

    @Override
    public long getCASelfSignedCertLifetime() throws CAMCryptoException {
        return this.getCANewCertificateLifetime() + 365L;
    }

    @Override
    public String getCASubjectDN() throws CAMCryptoException {
        return (String)this.configurationValues.get("caSubjectDN");
    }

    @Override
    public String getCATrustedPublisherKeyPairLocation() throws CAMCryptoException {
        return this.getCertificateDirectory() + File.separator + "jCAPublisherKeystore";
    }

    @Override
    public String getCATrustedPublisherPassword() throws CAMCryptoException {
        return "changeit";
    }

    @Override
    public URL getCAUrl() throws CAMCryptoException {
        URL caURL;
        URL urlActiveCm = this.getActiveCMUrl();
        if (urlActiveCm == null) {
            PriorityUrlList urls = this.getPeers();
            caURL = urls.getFirstURL();
        } else {
            caURL = this.convertCMUrlToDispatcherUrl(urlActiveCm);
        }
        return caURL;
    }

    @Override
    public String getCertificateDirectory() throws CAMCryptoException {
        return (String)this.configurationValues.get("certificateLocation");
    }

    @Override
    public String getClientDummyKeyPairAlias() throws CAMCryptoException {
        return "dummy";
    }

    @Override
    public String getConfidentialityAlgorithm() throws CAMCryptoException {
        return (String)this.configurationValues.get("confidentialityAlgorithm");
    }

    @Override
    public ICnfgFeedback getConfigFeedback() {
        return this.m_feedback;
    }

    @Override
    public String getConfiguredHMACAlgorithm() throws CAMCryptoException {
        return HMAC + this.getDigestAlgorithm().replace("SHA-", "SHA");
    }

    @Override
    public String getCSKAlgorithm() throws CAMCryptoException {
        return (String)this.configurationValues.get("cskAlgorithm");
    }

    @Override
    public String getCSKAlias() throws CAMCryptoException {
        return "csk";
    }

    @Override
    public String getCSKDigestAlgorithm() throws CAMCryptoException {
        return "SHA1";
    }

    @Override
    public String getCSKFormat() throws CAMCryptoException {
        return (String)this.configurationValues.get("cskKeystoreType");
    }

    @Override
    public long getCSKLifetime() throws CAMCryptoException {
        return (Long)this.configurationValues.get("CSKLifetime");
    }

    @Override
    public String getCSKLocation() throws CAMCryptoException {
        return (String)this.configurationValues.get("cskLocation");
    }

    @Override
    public String getCSKLocationForCPP() throws CAMCryptoException {
        return (String)this.configurationValues.get("cppCskLocation");
    }

    @Override
    public String getCSKPassword() throws CAMCryptoException {
        return (String)this.configurationValues.get("CSKPathPassword");
    }

    @Override
    public int getCSKSize() throws CAMCryptoException {
        return (Integer)this.configurationValues.get("cskKeySize");
    }

    @Override
    public String getJVMTrustStorePassword() throws CAMCryptoException {
        String jvmTrustStorePassword = (String)this.configurationValues.get("JVMTrustStorePassword");
        return jvmTrustStorePassword;
    }

    @Override
    public String getDigestAlgorithm() throws CAMCryptoException {
        String rawDigestAlgortithm = (String)this.configurationValues.get("digestAlgorithm");
        if (JVMEnvironment.getInstance().isFIPSEnabled()) {
            boolean isSHA1AndAllowed;
            String digestAlgorithm = (String)signatureMapping.get(rawDigestAlgortithm);
            boolean isFIPSAlgorithm = FIPS_DIGEST_ALGORITHMS.contains(digestAlgorithm);
            boolean bl = isSHA1AndAllowed = !JVMEnvironment.getInstance().OnlyUseSHA_2() && "SHA1".equals(digestAlgorithm);
            if (isFIPSAlgorithm || isSHA1AndAllowed) {
                return digestAlgorithm;
            }
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_invalid_digest_algorithm"));
        }
        return rawDigestAlgortithm;
    }

    private PriorityUrlList getDispatcherForEachCMURL() throws CAMCryptoException {
        Vector cmURLs = (Vector)this.configurationValues.get("contentManagers");
        PriorityUrlList dispURLs = null;
        URL tmpUrl = null;
        if (cmURLs != null) {
            dispURLs = new PriorityUrlList();
            for (URL cmURL : cmURLs) {
                tmpUrl = this.removeExtFromUri(cmURL);
                if (tmpUrl != null) {
                    dispURLs.addURL(this.convertCMUrlToDispatcherUrl(tmpUrl));
                    continue;
                }
                dispURLs.addURL(this.convertCMUrlToDispatcherUrl(cmURL));
            }
        }
        return dispURLs;
    }

    @Override
    public String getDNSuffix() throws CAMCryptoException {
        return (String)this.configurationValues.get("DNSuffix");
    }

    @Override
    public boolean getEnableSecureUserCapabilitiesCache() throws CAMCryptoException {
        return this.enableSecureUserCapabilitiesCache;
    }

    public boolean getEnableSSLHostnameVerification() {
        return this.enableSSLHostnameVerification;
    }

    @Override
    public String getEncryptionKeyPairAlgorithm() {
        return "RSA";
    }

    @Override
    public int getEncryptionKeyPairSize() throws CAMCryptoException {
        int sz = JNISystemProperties.getRSAKeyLength();
        return sz;
    }

    @Override
    public String getHMACAlgorithm() throws CAMCryptoException {
        return HMAC + this.getSHAAlgorithm();
    }

    @Override
    public String getHMACAlgorithm(String digestAlg) throws CAMCryptoException {
        return HMAC + digestAlg.replace("SHA-", "SHA");
    }

    private boolean getHostNameIsLocal(String hostname) {
        try {
            InetAddress localhost = InetAddress.getByName("127.0.0.1");
            InetAddress[] hostnamesIPs = InetAddress.getAllByName(hostname);
            InetAddress[] thishostsIPs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            for (int hostip = 0; hostip < hostnamesIPs.length; ++hostip) {
                if (hostnamesIPs[hostip].equals(localhost)) {
                    return true;
                }
                for (int thisip = 0; thisip < thishostsIPs.length; ++thisip) {
                    if (!thishostsIPs[thisip].equals(hostnamesIPs[hostip])) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getExternalDispatcherURI() {
        return this.externalDispatcherURL.toString();
    }

    @Override
    public String getInternalDispatcherURI() {
        return this.internalDispatcherURL.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getJSSECipherSuitesList() {
        if (this.jsseCipherSuites == null) {
            Configuration configuration = this;
            synchronized (configuration) {
                if (this.jsseCipherSuites == null) {
                    try {
                        this.jsseCipherSuites = this.constructJSSECipherSuitesList(true);
                    }
                    catch (CAMCryptoException cAMCryptoException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.jsseCipherSuites;
    }

    @Override
    public String[] getSSLProtocols() throws CAMCryptoException {
        if (this.sslProtocols == null) {
            Vector configuredSSLProtocolsVector = (Vector)this.configurationValues.get("SSLProtocols");
            if (configuredSSLProtocolsVector == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ssl_protocol_not_configured"));
            }
            this.sslProtocols = configuredSSLProtocolsVector.toArray(new String[configuredSSLProtocolsVector.size()]);
        }
        return this.sslProtocols;
    }

    @Override
    public String getJSSEProtocolName() throws CAMCryptoException {
        String[] protocols = this.getSSLProtocols();
        String wlpProtocol = null;
        if (protocols.length == 1) {
            if (protocols[0].compareTo("TLSv1.2") == 0) {
                wlpProtocol = "TLSv1.2";
            } else if (protocols[0].compareTo("TLSv1.1") == 0) {
                wlpProtocol = "TLSv1.1";
            }
        } else {
            wlpProtocol = JVMEnvironment.getInstance().isIBMJava() ? "SSL_TLSv2" : "TLS";
        }
        return wlpProtocol;
    }

    @Override
    public String getJSSEProviderName() throws CAMCryptoException {
        return JVMEnvironment.getInstance().getJSSEProviderName();
    }

    @Override
    public URL getLastUrlTried() {
        return this.m_lastUrlTried;
    }

    @Override
    public String getPDFEncryptionAlgorithm() {
        return (String)this.configurationValues.get("pdfAlgorithm");
    }

    @Override
    public int getPDFKeySizeInBits() throws CAMCryptoException {
        return (Integer)this.configurationValues.get("pdfKeySize");
    }

    @Override
    public int getPDFKeySizeInBytes() throws CAMCryptoException {
        int bitlen = this.getPDFKeySizeInBits();
        int bytelen = bitlen / 8;
        if (bitlen % 8 != 0) {
            IPFTraceFunction.trace("Configure:getPDFKeySizeInBytesChecking: our bitlength is not a factor of 8");
        }
        return bytelen;
    }

    @Override
    public URL getPeer() {
        PriorityUrlList urls = (PriorityUrlList)this.configurationValues.get("peerURL");
        return urls.getFirstURL();
    }

    @Override
    public PriorityUrlList getPeers() {
        return (PriorityUrlList)this.configurationValues.get("peerURL");
    }

    public synchronized CAMSSLSocketFactory getPKCS12SSLSocketFactory(String pkcs12File, String pkcs12FilePassword) throws CAMCryptoException, CertificateExpiredException, CertificateNotYetValidException {
        if (_pkcs12SSLSocketFactory != null) {
            return _pkcs12SSLSocketFactory;
        }
        try {
            SSLSocketFactory jsf = JVMEnvironment.getInstance().getPKCS12SSLSocketFactory(pkcs12File, pkcs12FilePassword);
            _supportedCipherSuites = jsf.getSupportedCipherSuites();
            _pkcs12SSLSocketFactory = new PKCS12JSSESSLSocketFactory(jsf);
        }
        catch (CAMCryptoException c) {
            throw new CAMCryptoException(c, MessageSet.getMessage("CAM_CRP_socket_factory_create_failed"));
        }
        return _pkcs12SSLSocketFactory;
    }

    @Override
    public String getSanDnsNames() {
        return (String)this.configurationValues.get("sanDNSName");
    }

    @Override
    public String getSanEmailAddrs() {
        return (String)this.configurationValues.get("sanEmail");
    }

    @Override
    public String getSanIPAddrs() {
        return (String)this.configurationValues.get("sanIPAddress");
    }

    @Override
    public String getServerCommonName() {
        return (String)this.configurationValues.get("serverCommonName");
    }

    @Override
    public String getServerDN() throws CAMCryptoException {
        return (String)this.configurationValues.get("ServerDN");
    }

    @Override
    public String getServerLocale() {
        String cfgLocale = (String)this.configurationValues.get("serverLocale");
        if (cfgLocale == null || cfgLocale.length() == 0) {
            cfgLocale = "en";
        }
        return cfgLocale;
    }

    @Override
    public String getSHAAlgorithm() throws CAMCryptoException {
        String shaAlg = null;
        shaAlg = JVMEnvironment.getInstance().isFIPSEnabled() ? "SHA256" : "SHA1";
        return shaAlg;
    }

    @Override
    public String getSigningKeyPairAlgorithm() throws CAMCryptoException {
        return (String)this.configurationValues.get("signingKeyPairAlgorithm");
    }

    @Override
    public int getSigningKeyPairSize() throws CAMCryptoException {
        int sz = 0;
        if (this.getSigningKeyPairAlgorithm().compareToIgnoreCase("RSA") == 0) {
            sz = JNISystemProperties.getRSAKeyLength();
        } else if (this.getSigningKeyPairAlgorithm().compareToIgnoreCase("DSA") == 0) {
            sz = JNISystemProperties.getDSAKeyLength();
        } else {
            IPFTraceFunction.fatalException("Error - Configuration.getSigningKeyPairSize: '" + this.getSigningKeyPairAlgorithm() + "' is not a supported Signing Key Pair algorithm.");
        }
        return sz;
    }

    @Override
    public String getTempFileLocation() throws CAMCryptoException {
        return (String)this.configurationValues.get("temp");
    }

    @Override
    public boolean getUsingThirdPartyCA() throws CAMCryptoException {
        return (Boolean)this.configurationValues.get("thirdPartyCA");
    }

    @Override
    public boolean getWeAreCDS() {
        String cdsValue = (String)this.configurationValues.get("DS_DATA_DIR");
        return cdsValue != null && cdsValue.length() != 0;
    }

    @Override
    public boolean getWeAreCFGAPI() throws CAMCryptoException {
        return this.weAreCFGAPI;
    }

    @Override
    public boolean getWeAreCM() {
        return (Boolean)this.configurationValues.get("serverRunningCM");
    }

    @Override
    public boolean getWeAreIPF() throws CAMCryptoException {
        return this.weAreIPF;
    }

    @Override
    public boolean getWeAreTheConfigTool() throws CAMCryptoException {
        return this.weAreTheConfigurationTool;
    }

    @Override
    public boolean isCAKeyPairValid() throws CAMCryptoException {
        X509Certificate caCert = (X509Certificate)KeyStoreReader.getCACertificate();
        if (caCert == null) {
            return false;
        }
        return new Date().before(caCert.getNotAfter());
    }

    @Override
    public boolean isContentManagerDisconnected() {
        if (this.disconnectContentManager == null) {
            return false;
        }
        return this.disconnectContentManager;
    }

    @Override
    public boolean isDecisionStreamRunning() {
        return this.serverRunningCDS;
    }

    @Override
    public boolean isHostConnectionSSL(String host, int port) throws CAMCryptoException {
        if (this.internalDispatcherURL != null && host.equals(this.internalDispatcherURL.getHost()) && port == this.internalDispatcherURL.getPort()) {
            return this.internalDispatcherURL.getProtocol().equals("https");
        }
        if (this.externalDispatcherURL != null && host.equals(this.externalDispatcherURL.getHost()) && port == this.externalDispatcherURL.getPort()) {
            return this.externalDispatcherURL.getProtocol().equals("https");
        }
        if (this.gatewayURL != null && host.equals(this.gatewayURL.getHost()) && port == this.gatewayURL.getPort()) {
            return this.gatewayURL.getProtocol().equals("https");
        }
        if (this.sdkURL != null && host.equals(this.sdkURL.getHost()) && port == this.sdkURL.getPort()) {
            return this.sdkURL.getProtocol().equals("https");
        }
        return false;
    }

    @Override
    public boolean isIdentityKeyPairValid() throws CAMCryptoException {
        X509Certificate encCert = (X509Certificate)KeyStoreReader.getEncryptionCertificateFromKeystore();
        if (encCert == null) {
            return false;
        }
        return new Date().before(encCert.getNotAfter());
    }

    @Override
    public boolean isMDMRunning() {
        return this.serverRunningMDM;
    }

    @Override
    public boolean isPeerConnectionSSL() throws CAMCryptoException {
        PriorityUrlList urls = (PriorityUrlList)this.configurationValues.get("peerURL");
        URL url = urls.getFirstURL();
        return url.getProtocol().equals("https");
    }

    @Override
    public boolean isStandaloneCA() throws CAMCryptoException {
        if (this.standaloneCA == null) {
            URL cmUrl;
            Boolean computedStandaloneCAValue = this.getCAIsEnabledForThisServer() ? ((cmUrl = this.getActiveCMUrl()) == null ? Boolean.TRUE : Boolean.FALSE) : Boolean.FALSE;
            this.standaloneCA = computedStandaloneCAValue;
        }
        return this.standaloneCA;
    }

    private void parseConfig(String configDoc, boolean isConfigTool) throws CAMCryptoException {
        boolean thirdPartyCAEnabled;
        PriorityUrlList cmDispURLs;
        int algSize;
        Object stringValue;
        this.configurationValues.clear();
        ContentHandler handler = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser parser = factory.newSAXParser();
            handler = new ContentHandler(this);
            parser.parse(new InputSource(new CharArrayReader(configDoc.toCharArray())), (DefaultHandler)handler);
        }
        catch (Exception e) {
            handler = null;
            throw new CAMCryptoException(e);
        }
        if (handler.getError() != null) {
            throw handler.getError();
        }
        handler = null;
        Boolean cmIsEnabledParam = (Boolean)this.configurationValues.get("cmIsEnabled");
        Boolean serverRunningCM = this.canWeCallCM(cmIsEnabledParam, isConfigTool);
        this.configurationValues.put("serverRunningCM", serverRunningCM);
        Object value = (String)this.configurationValues.get("serverLocale");
        if (value == null || ((String)value).length() == 0) {
            this.configurationValues.put("serverLocale", "en");
        }
        if ((value = (String)this.advancedConfigurationValues.get("EnableSecureUserCapabilitiesCache")) != null && ((String)value).length() != 0) {
            stringValue = value;
            if (((String)stringValue).equalsIgnoreCase("Yes") || ((String)stringValue).equalsIgnoreCase("True")) {
                this.enableSecureUserCapabilitiesCache = true;
            } else if (((String)stringValue).equalsIgnoreCase("No") || ((String)stringValue).equalsIgnoreCase("False")) {
                this.enableSecureUserCapabilitiesCache = false;
            }
        }
        if ((value = (String)this.advancedConfigurationValues.get("StandaloneCertificateAuthority")) != null && ((String)value).length() != 0) {
            stringValue = value;
            if (((String)stringValue).equalsIgnoreCase("Yes") || ((String)stringValue).equalsIgnoreCase("True")) {
                this.standaloneCA = Boolean.TRUE;
            } else if (((String)stringValue).equalsIgnoreCase("No") || ((String)stringValue).equalsIgnoreCase("False")) {
                this.standaloneCA = Boolean.FALSE;
            }
        }
        if ((value = (String)this.advancedConfigurationValues.get("StandaloneDispatcher")) != null && ((String)value).length() != 0) {
            stringValue = value;
            if (((String)stringValue).equalsIgnoreCase("Yes") || ((String)stringValue).equalsIgnoreCase("True")) {
                this.disconnectContentManager = Boolean.TRUE;
            } else if (((String)stringValue).equalsIgnoreCase("No") || ((String)stringValue).equalsIgnoreCase("False")) {
                this.disconnectContentManager = Boolean.FALSE;
            }
        }
        if ((value = (String)this.advancedConfigurationValues.get("EnableSSLHostnameVerification")) != null && ((String)value).length() != 0) {
            stringValue = value;
            if (((String)stringValue).equalsIgnoreCase("Yes") || ((String)stringValue).equalsIgnoreCase("True")) {
                this.enableSSLHostnameVerification = true;
            } else if (((String)stringValue).equalsIgnoreCase("No") || ((String)stringValue).equalsIgnoreCase("False")) {
                this.enableSSLHostnameVerification = false;
            }
        }
        value = Configuration._sanityGetParameter(this.configurationValues, "CSKPath", String.class);
        value = Configuration._sanityGetParameter(this.configurationValues, "CSKPathPassword", String.class);
        byte[] cskPwdBytes = ((String)value).getBytes();
        for (int i = 0; i < cskPwdBytes.length; ++i) {
            if (cskPwdBytes[i] >= 0) continue;
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_csk_password_has_extended_characters"));
        }
        value = Configuration._sanityGetParameter(this.configurationValues, "digestAlgorithm", String.class);
        if (((String)value).equalsIgnoreCase("SHA")) {
            value = this.configurationValues.put("digestAlgorithm", "SHA1");
        }
        value = Configuration._sanityGetParameter(this.configurationValues, "localCSK", Boolean.class);
        value = Configuration._sanityGetParameter(this.configurationValues, "signingKeyPairAlgorithm", String.class);
        value = Configuration._sanityGetParameter(this.configurationValues, "SSLConfidentiality", Boolean.class);
        value = Configuration._sanityGetParameter(this.configurationValues, "SSLMutualAuthentication", Boolean.class);
        String provType = (String)Configuration._sanityGetParameter(this.configurationValues, "cryptoProvider", String.class);
        String alg = null;
        value = Configuration._sanityGetParameter(this.configurationValues, "certificateAuthorityServiceCertificateLifetime", Long.class);
        if ((Long)value <= 0L) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_param_missing", new String[]{CAMCryptoUtilities.extractMsgString(MessageSet.getMessage("CAM_CRP_new_cert_lifetime"))}));
        }
        value = "";
        if (cmIsEnabledParam != null) {
            value = Configuration._sanityGetParameter(this.configurationValues, "certificateAuthorityServiceCommonName", String.class);
        }
        if (((String)value).length() == 0) {
            this.configurationValues.put("distinguishedNameOrganization", "CA");
        }
        if (((String)(value = Configuration._sanityGetParameter(this.configurationValues, "certificateAuthorityServicePassword", String.class))).length() == 0) {
            this.configurationValues.put("certificateAuthorityServicePassword", "capass");
        }
        value = Configuration._sanityGetParameter(this.configurationValues, "certificateLocation", String.class);
        value = Configuration._sanityGetParameter(this.configurationValues, "distinguishedNameCountry", String.class);
        if (((String)value).length() == 0) {
            this.configurationValues.put("distinguishedNameCountry", "CA");
        }
        if (((String)(value = Configuration._sanityGetParameter(this.configurationValues, "distinguishedNameOrganization", String.class))).length() == 0) {
            this.configurationValues.put("distinguishedNameOrganization", "Cognos");
        }
        if (((String)(value = Configuration._sanityGetParameter(this.configurationValues, "serverCommonName", String.class))).length() == 0) {
            this.configurationValues.put("serverCommonName", "CAMUSER");
        }
        value = Configuration._sanityGetParameter(this.configurationValues, "thirdPartyCA", Boolean.class);
        try {
            alg = (String)Configuration._sanityGetParameter(this.configurationValues, "cognosCryptoConfidentialityAlgorithm", String.class);
        }
        catch (CAMCryptoException e1) {
            alg = (String)Configuration._sanityGetParameter(this.configurationValues, "confidentialityAlgorithm", String.class);
        }
        StringBuffer sb = new StringBuffer("");
        IPFTraceFunction.trace("Checking support for algorithm: " + alg);
        if (!JNISystemProperties.checkAlgorithm((String)alg, (StringBuffer)sb)) {
            IPFTraceFunction.trace("Check for algorithm support returns false.");
            if (sb.length() > 0) {
                IPFTraceFunction.trace("JNI Message: " + new String(sb));
            }
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_provider_unsupported_alg", new String[]{alg}));
        }
        IPFTraceFunction.trace("Check for algorithm support returns true.");
        if (sb.length() > 0) {
            IPFTraceFunction.trace("JNI Message: " + new String(sb));
        }
        this.configurationValues.put("confidentialityAlgorithm", alg);
        if (alg.equalsIgnoreCase("RC2-40")) {
            alg = "RC2";
            algSize = 40;
        } else if (alg.equalsIgnoreCase("RC2")) {
            alg = "RC2";
            algSize = 128;
        } else if (alg.equalsIgnoreCase("RC4-40")) {
            alg = "RC4";
            algSize = 40;
        } else if (alg.equalsIgnoreCase("RC4")) {
            alg = "RC4";
            algSize = 128;
        } else if (alg.equalsIgnoreCase("3DES")) {
            alg = "DESede";
            algSize = 168;
        } else if (alg.equalsIgnoreCase("DES")) {
            alg = "DES";
            algSize = 56;
        } else if (alg.equalsIgnoreCase("AES")) {
            alg = "AES";
            algSize = 128;
        } else if (alg.equalsIgnoreCase("AES128")) {
            alg = "AES";
            algSize = 128;
        } else if (alg.equalsIgnoreCase("AES256")) {
            alg = "AES";
            algSize = 256;
        } else {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_unsuported_csk_alg_error", new String[]{alg}));
        }
        this.configurationValues.put("cskAlgorithm", alg);
        this.configurationValues.put("cskKeySize", algSize);
        this.configurationValues.put("cskLocation", this.configurationValues.get("CSKPath") + File.separator + "jCSKKeystore");
        this.configurationValues.put("cppCskLocation", this.configurationValues.get("CSKPath") + File.separator + "cCSKKeystore");
        String certsDir = (String)this.configurationValues.get("certificateLocation");
        String installID = CAMCryptoUtilities.getCAMInstallationIdentifier(certsDir);
        this.configurationValues.put("DNSuffix", ",O=" + this.configurationValues.get("distinguishedNameOrganization") + ",C=" + this.configurationValues.get("distinguishedNameCountry"));
        this.configurationValues.put("ServerDN", "CN=" + this.configurationValues.get("serverCommonName") + this.configurationValues.get("DNSuffix"));
        this.configurationValues.put("caSubjectDN", "CN=" + this.configurationValues.get("certificateAuthorityServiceCommonName") + ",CN=" + installID + this.configurationValues.get("DNSuffix"));
        this.configurationValues.put("cskKeystoreType", "JCEKS");
        String pkcs12KeystoreType = JVMEnvironment.getInstance().getPKCS12KeystoreType();
        this.configurationValues.put("caKeystoreType", pkcs12KeystoreType);
        this.configurationValues.put("camKeystoreLocation", this.configurationValues.get("certificateLocation") + File.separator + "CAMKeystore");
        String pdfAlg = null;
        try {
            pdfAlg = (String)Configuration._sanityGetParameter(this.configurationValues, "cognosPDFConfidentialityAlgorithm", String.class);
        }
        catch (CAMCryptoException e1) {
            pdfAlg = new String("RC4-40");
        }
        int pdfalgSize = 0;
        if (pdfAlg.equalsIgnoreCase("RC4-40")) {
            pdfAlg = "RC4";
            pdfalgSize = 40;
        } else if (pdfAlg.equalsIgnoreCase("RC4")) {
            pdfAlg = "RC4";
            pdfalgSize = 128;
        } else if (pdfAlg.equalsIgnoreCase("AES")) {
            pdfAlg = "AES";
            pdfalgSize = 128;
        } else if (pdfAlg.equalsIgnoreCase("AES256")) {
            pdfAlg = "AES";
            pdfalgSize = 256;
        } else {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencryptunsuported_alg_error", new String[]{alg}));
        }
        this.configurationValues.put("pdfAlgorithm", pdfAlg);
        this.configurationValues.put("pdfKeySize", pdfalgSize);
        Boolean boolDispEnabled = (Boolean)this.configurationValues.get("dispIsEnabled");
        boolean dispIsEnabled = true;
        if (boolDispEnabled != null) {
            dispIsEnabled = boolDispEnabled;
        }
        String cdsDataDir = null;
        cdsDataDir = (String)this.configurationValues.get("DS_DATA_DIR");
        this.serverRunningCDS = cdsDataDir != null && cdsDataDir.length() > 0;
        this.configurationValues.put("serverRunningCDS", new Boolean(this.serverRunningCDS));
        String mdmService = null;
        mdmService = (String)this.configurationValues.get("mdmService");
        String MDCSettings = (String)this.configurationValues.get("MDCSettings");
        this.serverRunningMDM = mdmService != null && mdmService.length() > 0 || MDCSettings != null && MDCSettings.length() > 0;
        String tm1Server = null;
        tm1Server = (String)this.configurationValues.get("tm1Server");
        String tm1AdminServer = null;
        tm1AdminServer = (String)this.configurationValues.get("tm1AdminServer");
        String pmpServer = null;
        pmpServer = (String)this.configurationValues.get("pmpService");
        String tm1ExcelService = null;
        tm1ExcelService = (String)this.configurationValues.get("tm1ExcelService");
        this.serverRunningTM1 = tm1Server != null && tm1Server.length() > 0 || tm1AdminServer != null && tm1AdminServer.length() > 0 || pmpServer != null && pmpServer.length() > 0 || tm1ExcelService != null && tm1ExcelService.length() > 0;
        this.configurationValues.put("serverRunningTM1", new Boolean(this.serverRunningTM1));
        URL tmpUrl = null;
        this.internalDispatcherURL = (URL)this.configurationValues.get("internalDispatcher");
        tmpUrl = this.removeExtFromUri(this.internalDispatcherURL);
        if (tmpUrl != null) {
            this.internalDispatcherURL = tmpUrl;
        }
        this.externalDispatcherURL = (URL)this.configurationValues.get("externalDispatcher");
        tmpUrl = this.removeExtFromUri(this.externalDispatcherURL);
        if (tmpUrl != null) {
            this.externalDispatcherURL = tmpUrl;
        }
        this.sdkURL = (URL)this.configurationValues.get("sdk");
        tmpUrl = this.removeExtFromUri(this.sdkURL);
        if (tmpUrl != null) {
            this.sdkURL = tmpUrl;
        }
        this.gatewayURL = (URL)this.configurationValues.get("gateway");
        tmpUrl = this.removeExtFromUri(this.gatewayURL);
        if (tmpUrl != null) {
            this.gatewayURL = tmpUrl;
        }
        PriorityUrlList peerURLs = new PriorityUrlList();
        if (dispIsEnabled && (isConfigTool || !serverRunningCM.booleanValue()) && (cmDispURLs = this.getDispatcherForEachCMURL()) != null) {
            Iterator<URL> it = cmDispURLs.getIterator();
            while (it.hasNext()) {
                peerURLs.addURL(it.next());
            }
        }
        Vector<URL> filteredGwDispUris = new Vector<URL>();
        Vector<URL> gatewayDispatcherURIs = (Vector<URL>)this.configurationValues.get("gatewayDispatcherURIList");
        if (gatewayDispatcherURIs != null) {
            for (URL gwURL : gatewayDispatcherURIs) {
                URL retGWUrl = this.removeExtFromUri(gwURL);
                if (retGWUrl != null) {
                    filteredGwDispUris.add(retGWUrl);
                    continue;
                }
                filteredGwDispUris.add(gwURL);
            }
            gatewayDispatcherURIs = filteredGwDispUris;
        }
        if (this.internalDispatcherURL != null && dispIsEnabled) {
            peerURLs.addURL(this.internalDispatcherURL);
        }
        if (this.externalDispatcherURL != null && dispIsEnabled) {
            peerURLs.addURL(this.externalDispatcherURL);
        }
        if (gatewayDispatcherURIs != null) {
            Iterator it = gatewayDispatcherURIs.iterator();
            while (it.hasNext()) {
                peerURLs.addURL((URL)it.next());
            }
        }
        if (this.gatewayURL != null) {
            peerURLs.addURL(this.gatewayURL);
        }
        if (this.sdkURL != null) {
            peerURLs.addURL(this.sdkURL);
        }
        if (thirdPartyCAEnabled = ((Boolean)this.configurationValues.get("thirdPartyCA")).booleanValue()) {
            this.configurationValues.put("caIsEnabledForThisServer", new Boolean(false));
        } else {
            boolean caIsEnabledForThisServer = serverRunningCM != false || this.serverRunningCDS || this.serverRunningMDM || this.serverRunningTM1;
            this.configurationValues.put("caIsEnabledForThisServer", new Boolean(caIsEnabledForThisServer));
        }
        this.configurationValues.put("peerURL", peerURLs);
        this.constructJSSECipherSuitesList(false);
        String standardConformance = (String)this.configurationValues.get("cryptoStandardConformance");
        if (standardConformance == null || 0 == standardConformance.compareTo("NIST_SP_800_131A")) {
            System.setProperty("com.ibm.jsse2.SP800-131", "strict");
            JVMEnvironment.getInstance().setEnableNIST_SP_800_131A();
        } else if (0 == standardConformance.compareTo("IBM_Cognos")) {
            JVMEnvironment.getInstance().setDisableNIST131a(true);
        } else {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_config_param_missing", new String[]{"cryptoStandardConformance"}));
        }
    }

    URL removeExtFromUri(URL givenUri) throws CAMCryptoException {
        if (givenUri != null) {
            String givenUriPath = givenUri.getPath();
            if (givenUriPath.endsWith(ext)) {
                String url = givenUri.toString();
                int pathlen = url.length();
                String newSpec = url.substring(0, pathlen -= ext.length());
                URL newUrl = null;
                try {
                    newUrl = new URL(newSpec);
                }
                catch (MalformedURLException e) {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_peer_unknown"));
                }
                return newUrl;
            }
            return null;
        }
        return null;
    }

    @Override
    public void setConfigFeedback(ICnfgFeedback feedback) throws CAMCryptoException {
        if (feedback == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        this.m_feedback = feedback;
    }

    @Override
    public void setLastUrlTried(URL lastUrlTried) {
        this.m_lastUrlTried = lastUrlTried;
    }

    @Override
    public void setWeAreCFGAPI(boolean isCFGAPI) throws CAMCryptoException {
        this.weAreCFGAPI = isCFGAPI;
    }

    @Override
    public void setWeAreIPF(boolean isIPF) throws CAMCryptoException {
        this.weAreIPF = isIPF;
    }

    @Override
    public void setWeAreTheConfigTool(boolean isTheConfigurationTool) throws CAMCryptoException {
        this.weAreTheConfigurationTool = isTheConfigurationTool;
    }

    @Override
    public boolean useConfidentiality() throws CAMCryptoException {
        return (Boolean)this.configurationValues.get("SSLConfidentiality");
    }

    @Override
    public boolean useMutualAuthentication() throws CAMCryptoException {
        return (Boolean)this.configurationValues.get("SSLMutualAuthentication");
    }

    private class ContentHandler
    extends DefaultHandler {
        int indent;
        private Configuration _outer;
        private int _state;
        private String _currentValueType;
        private boolean _currentValueIsEncrypted;
        private String _currentValueName;
        private String _currentSortedArrayOrder;
        private Vector _stateStack;
        private CAMCryptoException _error;
        private StringBuffer _currentValueChars;
        private Vector _array;
        private static final int kStateStart = 0;
        private static final int kStateInsideEnviroment = 1;
        private static final int kStateInsideCryptoTag = 2;
        private static final int kStateInsideOuterValueTag = 3;
        private static final int kStateInsideParameterTag = 4;
        private static final int kStateInsideInnerValueTag = 5;
        private static final int kStateInsideInstances = 6;
        private static final int kStateInsideInstance = 7;
        private static final int kStateInsideOpaque = 8;
        private static final int kStateInsideContentManagersTag = 9;
        private static final int kStateInsideArrayTag = 10;
        private static final int kStateInsideItemValueTag = 11;
        private static final int kStateInsideCBSTag = 12;
        private static final int kStateInsideCipherSuitesTag = 13;
        private static final int kStateInsideGatewayDispURITag = 14;
        private static final int kStateInsideCDSTag = 15;
        private static final int kStateInsideCDSNetTag = 16;
        private static final int kStateInsideMDMServiceTag = 17;
        private static final int kStateInsideAdvancedPropertiesTag = 18;
        private static final int kStateInsideAdvancedPropertiesArrayTag = 19;
        private static final int kStateInsidePlanningTag = 20;
        private static final int kStateInsideTM1ServiceTag = 21;
        private static final int kStateInsideSSLProtocolsTag = 22;
        private static final int kStateInsideAdvancedConfigurationTag = 23;
        private static final String kNamespaceURIEmpty = "";
        private static final String kNamespaceURICrnConfig = "http://developer.cognos.com/schemas/crconfig/1/";
        private static final String kNamespaceURIXsi = "http://www.w3.org/2001/XMLSchema-instance";
        private static final String kAttributeName = "name";
        private static final String kAttributeType = "type";
        private static final String kAttributeEncrypted = "encrypted";
        private static final String kAttributeClass = "class";
        private static final String kAttributeOpaque = "opaque";
        private static final String kElementValue = "value";
        private static final String kElementParameter = "parameter";
        private static final String kElementParameters = "parameters";
        private static final String kElementInstances = "instances";
        private static final String kElementInstance = "instance";
        private static final String kElementItem = "item";
        private static final String kValueCrypto = "CRYPTO";
        private static final String kValueCBS = "CBS";
        private static final String kValueContentManagers = "contentManagers";
        private static final String kValueGatewayDispatcherURIList = "gatewayDispatcherURIList";
        private static final String kValueCognosCryptoCipherSuite = "cognosCryptoCiphersuite";
        private static final String kValueSSLProtocols = "SSLProtocols";
        private static final String kValueCDS = "CDS";
        private static final String kValuePlanning = "PLANNING";
        private static final String kValueCDSNet = "CDSNet";
        private static final String kValueCDSNetServer = "CDSNetServer";
        private static final String kValueCDSNetClient = "CDSNetClient";
        private static final String kValueCDSNetSoapServer = "CDSNetSOAPServer";
        private static final String kValueCDSNetSocketServer = "CDSNetSocketServer";
        private static final String kValueMDMService = "mdmService";
        private static final String kValueMDCSettings = "MDCSettings";
        private static final String kValueAdvancedPropertiess = "advancedProperties";
        private static final String kValueStandaloneCA = "StandaloneCertificateAuthority";
        private static final String kValueDisconnectContentManager = "DisconnectContentManager";
        private static final String kValueEnableSecureUserCapabilitiesCache = "EnableSecureUserCapabilitiesCache";
        private static final String kValueEnableSSLHostnameVerificateion = "EnableSSLHostnameVerification";
        private static final String kValuePmpService = "pmpService";
        private static final String kValuetm1AdminServer = "tm1AdminServer";
        private static final String kValuetm1ExcelService = "tm1ExcelService";
        private static final String kValuetm1Server = "tm1Server";
        private static final String kTypeBoolean = "boolean";
        private static final String kTypeFolderPath = "folderPath";
        private static final String kTypeLong = "long";
        private static final String kTypeString = "string";
        private static final String kTypeSystemPassword = "systemPassword";
        private static final String kTypeSystemAnyURI = "anyURI";
        private static final String kTypeSystemLocalURI = "localURI";

        public ContentHandler(Configuration outer) {
            this._outer = outer;
            this._error = null;
            this._stateStack = new Vector();
            this._currentValueChars = new StringBuffer();
            this._array = new Vector();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this._error != null) {
                return;
            }
            if (this._state == 5 || this._state == 11 || this._state == 23) {
                this._currentValueChars.append(ch, start, length);
            }
        }

        private boolean isCAMCryptoAdvancedConfiguration(String attributeName) {
            return attributeName.compareToIgnoreCase(kValueStandaloneCA) == 0 || attributeName.compareToIgnoreCase(kValueDisconnectContentManager) == 0 || attributeName.compareToIgnoreCase(kValueEnableSecureUserCapabilitiesCache) == 0 || attributeName.compareToIgnoreCase(kValueEnableSSLHostnameVerificateion) == 0;
        }

        private Object convertToType(String type, String svalue) {
            try {
                Object ovalue = null;
                type = type.substring(type.indexOf(58) + 1);
                if (kTypeBoolean.equalsIgnoreCase(type)) {
                    ovalue = svalue != null ? Boolean.valueOf(svalue) : new Boolean(false);
                } else if (kTypeFolderPath.equalsIgnoreCase(type)) {
                    ovalue = svalue != null ? this._outer.cclConfigObj.resolveEffectivePath(svalue) : kNamespaceURIEmpty;
                } else if (kTypeLong.equalsIgnoreCase(type)) {
                    ovalue = svalue != null ? Long.valueOf(svalue) : new Long(0L);
                } else if (kTypeString.equalsIgnoreCase(type)) {
                    ovalue = svalue != null ? svalue : kNamespaceURIEmpty;
                } else if (kTypeSystemPassword.equalsIgnoreCase(type)) {
                    if (svalue != null) {
                        if (this._currentValueIsEncrypted) {
                            byte[] b64ciphertext = svalue.getBytes();
                            byte[] ciphertext = CryptoWrapper.decodeBase64(b64ciphertext);
                            byte[] cleartext = Configuration.this.systemProtectionSession.decryptData(ciphertext);
                            ovalue = new String(cleartext, "UTF-8");
                        } else {
                            ovalue = svalue;
                        }
                    } else {
                        ovalue = kNamespaceURIEmpty;
                    }
                } else {
                    ovalue = kTypeSystemAnyURI.equalsIgnoreCase(type) || kTypeSystemLocalURI.equalsIgnoreCase(type) ? (svalue != null ? new URL(svalue) : new URL("http://empty/value")) : svalue;
                }
                return ovalue;
            }
            catch (NumberFormatException nfe) {
                this._error = new CAMCryptoException(nfe, kNamespaceURIEmpty);
                return null;
            }
            catch (MalformedURLException mue) {
                this._error = new CAMCryptoException(mue, kNamespaceURIEmpty);
                return null;
            }
            catch (UnsupportedEncodingException uee) {
                this._error = new CAMCryptoException(uee, kNamespaceURIEmpty);
                return null;
            }
            catch (CAMCryptoException cce) {
                this._error = cce;
                return null;
            }
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            Object ovalue;
            if (this._error != null) {
                return;
            }
            if (this._state == 5) {
                ovalue = this.convertToType(this._currentValueType, this._currentValueChars.toString().trim());
                this._outer.configurationValues.put(this._currentValueName, ovalue);
            }
            if (this._state == 23) {
                ovalue = this.convertToType(this._currentValueType, this._currentValueChars.toString().trim());
                this._outer.advancedConfigurationValues.put(this._currentValueName, ovalue);
            } else if (this._state == 11) {
                if (name.equalsIgnoreCase(kElementItem)) {
                    ovalue = this.convertToType(this._currentValueType, this._currentValueChars.toString());
                    if (this._currentSortedArrayOrder != null) {
                        int order = Integer.parseInt(this._currentSortedArrayOrder);
                        if (order < 0 || order > 35) {
                            return;
                        }
                        if (this._array.size() <= order) {
                            this._array.setSize(order + 1);
                        }
                        this._array.setElementAt(ovalue, order);
                    } else {
                        this._array.add(ovalue);
                    }
                }
            } else if (this._state == 10) {
                this._outer.configurationValues.put(this._currentValueName, this._array.clone());
            }
            this._state = (Integer)this._stateStack.lastElement();
            this._stateStack.remove(this._stateStack.size() - 1);
        }

        public CAMCryptoException getError() {
            return this._error;
        }

        @Override
        public void startDocument() {
            this.indent = 10;
            this._state = 0;
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            String n;
            if (this._error != null) {
                return;
            }
            this._stateStack.add(this._state);
            if (this._state == 0 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementParameters)) {
                this._state = 1;
                return;
            }
            if (this._state == 1 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementParameter)) {
                n = atts.getValue(kNamespaceURIEmpty, kAttributeName);
                if (n.equalsIgnoreCase(kValueCrypto)) {
                    this._state = 2;
                    return;
                }
                if (n.equalsIgnoreCase(kValueContentManagers)) {
                    this._currentValueName = n;
                    this._state = 9;
                    return;
                }
                if (n.equalsIgnoreCase(kValueGatewayDispatcherURIList)) {
                    this._currentValueName = n;
                    this._state = 14;
                    return;
                }
                if (n.equalsIgnoreCase(kValueCBS)) {
                    this._currentValueName = n;
                    this._state = 12;
                    return;
                }
                if (n.equalsIgnoreCase(kValueCDS)) {
                    this._currentValueName = n;
                    this._state = 15;
                    return;
                }
                if (n.equalsIgnoreCase(kValuePlanning)) {
                    this._currentValueName = n;
                    this._state = 20;
                    return;
                }
                if (n.equalsIgnoreCase(kValueMDMService)) {
                    this._currentValueName = n;
                    this._state = 17;
                    this._currentValueChars.delete(0, this._currentValueChars.length());
                    return;
                }
                if (n.equalsIgnoreCase(kValueMDCSettings)) {
                    this._currentValueName = n;
                    this._state = 17;
                    this._currentValueChars.delete(0, this._currentValueChars.length());
                    return;
                }
                if (n.equalsIgnoreCase(kValuePmpService) || n.equalsIgnoreCase(kValuetm1AdminServer) || n.equalsIgnoreCase(kValuetm1ExcelService) || n.equalsIgnoreCase(kValuetm1Server)) {
                    this._currentValueName = n;
                    this._state = 21;
                    this._currentValueChars.delete(0, this._currentValueChars.length());
                    return;
                }
                if (n.equalsIgnoreCase(kValueAdvancedPropertiess)) {
                    this._state = 18;
                    return;
                }
            }
            if (this._state == 18 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 19;
                return;
            }
            if (this._state == 19 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementParameter)) {
                String attributeName = atts.getValue(kNamespaceURIEmpty, kAttributeName);
                if (this.isCAMCryptoAdvancedConfiguration(attributeName)) {
                    this._currentValueName = attributeName;
                    this._currentValueType = new String("xsd:string");
                    this._state = 23;
                    this._currentValueChars.delete(0, this._currentValueChars.length());
                }
                return;
            }
            if (this._state == 9 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 10;
                this._array.clear();
                return;
            }
            if (this._state == 14 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 10;
                this._array.clear();
                return;
            }
            if (this._state == 13 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 10;
                this._array.clear();
                return;
            }
            if (this._state == 22 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 10;
                this._array.clear();
                return;
            }
            if (this._state == 10 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementItem)) {
                this._currentValueType = atts.getValue(kNamespaceURIXsi, kAttributeType);
                this._currentValueChars.delete(0, this._currentValueChars.length());
                this._currentSortedArrayOrder = atts.getValue("order");
                this._state = 11;
                return;
            }
            if (this._state == 11 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementItem)) {
                this._currentValueType = atts.getValue(kNamespaceURIXsi, kAttributeType);
                this._currentValueChars.delete(0, this._currentValueChars.length());
                return;
            }
            if (this._state == 2 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 3;
                return;
            }
            if (this._state == 12 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 3;
                return;
            }
            if (this._state == 15 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 3;
                return;
            }
            if (this._state == 20 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 3;
                return;
            }
            if (this._state == 16 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 5;
                return;
            }
            if ((this._state == 17 || this._state == 21) && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._state = 5;
                this._currentValueType = new String("xsd:string");
                this._currentValueChars.append("present");
                return;
            }
            if (this._state == 3 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementParameter)) {
                n = atts.getValue(kNamespaceURIEmpty, kAttributeName);
                if (n.equalsIgnoreCase(kValueCognosCryptoCipherSuite)) {
                    this._currentValueName = n;
                    this._state = 13;
                    return;
                }
                if (n.equalsIgnoreCase(kValueSSLProtocols)) {
                    this._currentValueName = n;
                    this._state = 22;
                    return;
                }
                if (n.equalsIgnoreCase(kValueCDSNet) || n.equalsIgnoreCase(kValueCDSNetServer) || n.equalsIgnoreCase(kValueCDSNetClient) || n.equalsIgnoreCase(kValueCDSNetSoapServer) || n.equalsIgnoreCase(kValueCDSNetSocketServer)) {
                    this._state = 3;
                    return;
                }
                this._currentValueName = n;
                if (this._currentValueName == null) {
                    this._currentValueName = new String();
                }
                this._state = 4;
                return;
            }
            if (this._state == 1 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementParameter)) {
                String opaque = atts.getValue(kNamespaceURIEmpty, kAttributeOpaque);
                if (opaque != null && opaque.equalsIgnoreCase("true")) {
                    this._state = 8;
                    return;
                }
                this._currentValueName = atts.getValue(kNamespaceURIEmpty, kAttributeName);
                if (this._currentValueName == null) {
                    this._currentValueName = new String();
                }
                this._state = 4;
                return;
            }
            if (this._state == 3 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementInstances)) {
                this._currentValueName = atts.getValue(kNamespaceURIEmpty, kAttributeName);
                if (this._currentValueName == null) {
                    this._currentValueName = new String();
                }
                this._state = 6;
                return;
            }
            if (this._state == 6 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementInstance)) {
                String c = atts.getValue(kNamespaceURIEmpty, kAttributeClass);
                if (c == null) {
                    c = new String();
                }
                this._outer.configurationValues.put(this._currentValueName, c);
                this._state = 3;
                return;
            }
            if (this._state == 4 && uri.equalsIgnoreCase(kNamespaceURICrnConfig) && name.equalsIgnoreCase(kElementValue)) {
                this._currentValueType = atts.getValue(kNamespaceURIXsi, kAttributeType);
                if (this._currentValueType == null) {
                    this._currentValueType = new String();
                }
                this._currentValueIsEncrypted = false;
                String isEncrypted = atts.getValue(kNamespaceURIEmpty, kAttributeEncrypted);
                if (isEncrypted != null && isEncrypted.equalsIgnoreCase("true")) {
                    this._currentValueIsEncrypted = true;
                }
                this._state = 5;
                this._currentValueChars.delete(0, this._currentValueChars.length());
                return;
            }
        }
    }
}

