/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.res.MessageSet;

public class EncodedCSKRequest {
    public static final byte VERSION = 2;
    private static final byte TYPE_ADDITINAL_INFO = 1;
    private static final byte TYPE_IP = 2;
    private static final byte TYPE_DIGEST = 3;
    private static final byte TYPE_PKCS1 = 4;
    private static final byte TYPE_PKCS7 = 5;
    public static final byte RESP_SUCCESS = 0;
    public static final byte RESP_ERROR = 9;
    private byte[] addInfo;
    private byte[] locale;
    private byte[] installID;
    private byte[] ip;
    private byte[] digest;
    private byte[] cert;
    private boolean returnPKCS7 = false;
    static final int MAX_ADDINFO_LENGTH = 56;
    static final int MAX_IP_LENGTH = 64;
    static final int MAX_DIGEST_LENGTH = 64;
    static IPFTraceLogger cskTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CSK");

    public EncodedCSKRequest(byte[] locale, byte[] ip, byte[] cert, byte[] digest) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        String certsDir = config.getCertificateDirectory();
        String installID = CAMCryptoUtilities.getCAMInstallationIdentifier(certsDir);
        int pt = 0;
        byte[] additionalInfo = new byte[locale.length + installID.length() + 1];
        System.arraycopy(locale, 0, additionalInfo, pt, locale.length);
        System.arraycopy("|".getBytes(), 0, additionalInfo, pt += locale.length, 1);
        System.arraycopy(installID.getBytes(), 0, additionalInfo, ++pt, installID.length());
        pt += locale.length;
        this.addInfo = additionalInfo;
        this.ip = ip;
        this.cert = cert;
        this.digest = digest;
    }

    public EncodedCSKRequest() {
    }

    public byte[] getIP() {
        return this.ip;
    }

    public byte[] getLocale() {
        return this.locale;
    }

    public byte[] getInstallID() {
        return this.installID;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public byte[] getCert() {
        return this.cert;
    }

    public byte[] genCSKRequest() throws CAMCryptoException {
        if (this.ip == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_csk_request_ip"));
        }
        if (this.addInfo == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_csk_request_locale"));
        }
        if (this.cert == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_not_able_to_generate_csk_request_cert"));
        }
        int requestLength = this.ip.length + 2 + this.addInfo.length + 2 + this.cert.length + 5;
        if (this.digest != null) {
            requestLength = requestLength + this.digest.length + 2;
        }
        byte[] cskRequest = new byte[requestLength + 1];
        cskRequest[0] = 2;
        int pt = 1;
        cskRequest[pt] = 1;
        cskRequest[++pt] = (byte)this.addInfo.length;
        System.arraycopy(this.addInfo, 0, cskRequest, ++pt, this.addInfo.length);
        cskRequest[pt += this.addInfo.length] = 2;
        cskRequest[++pt] = (byte)this.ip.length;
        System.arraycopy(this.ip, 0, cskRequest, ++pt, this.ip.length);
        cskRequest[pt += this.ip.length] = 4;
        byte[] byteCertLength = CryptoWrapper.toByteArray(this.cert.length);
        System.arraycopy(byteCertLength, 0, cskRequest, ++pt, 4);
        System.arraycopy(this.cert, 0, cskRequest, pt += 4, this.cert.length);
        pt += this.cert.length;
        if (this.digest != null) {
            cskRequest[pt] = 3;
            cskRequest[++pt] = (byte)this.digest.length;
            System.arraycopy(this.digest, 0, cskRequest, ++pt, this.digest.length);
            pt += this.digest.length;
        }
        return cskRequest;
    }

    public boolean parseCSKRequest(byte[] cskRequest) throws CAMCryptoException {
        int length = 0;
        block6: for (int pt = 1; pt < cskRequest.length; pt += length) {
            byte type = cskRequest[pt];
            ++pt;
            switch (type) {
                case 1: {
                    length = cskRequest[pt];
                    if (length > 56) {
                        cskTraceLogger.trace("Invalide size of Locale: " + length);
                        return false;
                    }
                    this.addInfo = new byte[length];
                    System.arraycopy(cskRequest, ++pt, this.addInfo, 0, length);
                    String addInfoString = new String(this.addInfo);
                    String[] addInfoToken = addInfoString.split("\\|");
                    if (addInfoToken.length == 1) {
                        this.locale = addInfoToken[0].getBytes();
                        continue block6;
                    }
                    if (addInfoToken.length == 2) {
                        this.locale = addInfoToken[0].getBytes();
                        this.installID = addInfoToken[1].getBytes();
                        continue block6;
                    }
                    this.locale = null;
                    this.installID = null;
                    continue block6;
                }
                case 2: {
                    length = cskRequest[pt];
                    if (length > 64) {
                        cskTraceLogger.trace("Invalide size of IP addres: " + length);
                        return false;
                    }
                    this.ip = new byte[length];
                    System.arraycopy(cskRequest, ++pt, this.ip, 0, length);
                    continue block6;
                }
                case 3: {
                    length = cskRequest[pt];
                    if (length > 64) {
                        cskTraceLogger.trace("Invalide size of CSK digest: " + length);
                        return false;
                    }
                    this.digest = new byte[length];
                    System.arraycopy(cskRequest, ++pt, this.digest, 0, length);
                    continue block6;
                }
                case 4: 
                case 5: {
                    byte[] byteCertLength = new byte[4];
                    System.arraycopy(cskRequest, pt, byteCertLength, 0, 4);
                    length = CryptoWrapper.toInt(byteCertLength, 0, 4);
                    this.cert = new byte[length];
                    System.arraycopy(cskRequest, pt += 4, this.cert, 0, length);
                    if (type != 5) continue block6;
                    this.returnPKCS7 = true;
                    continue block6;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isReturnPKCS7() {
        return this.returnPKCS7;
    }
}

