/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.LoggableObject;
import com.cognos.accman.jcam.crypto.misc.IPFFunction;
import com.cognos.accman.jcam.crypto.misc.IPFSwitch;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class IPFTraceFunction
extends IPFFunction {
    private static final int LEVEL = 10000;
    private static LogTypedLogger traceLogger;

    public IPFTraceFunction(String functionName, LoggableObject callerObject) {
        super(functionName, callerObject);
    }

    public IPFTraceFunction(String functionName) {
        super(functionName);
    }

    public static void debugPrint(String message) {
        try {
            Thread currentThread = Thread.currentThread();
            String threadname = currentThread.toString();
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd 'at' H:mm:ss:SSS");
            String timenow = sdf.format(cal.getTime());
            String camcryptoDebugFile = ".." + File.separator + "logs" + File.separator + "camcrypto_debug.log";
            FileOutputStream fos = new FileOutputStream(camcryptoDebugFile, true);
            PrintWriter pw = new PrintWriter(fos);
            pw.println(timenow + " " + threadname + " : " + message);
            pw.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public static void fatalException(String message) {
        if (!IPFFunction.isEnabled(traceLogger, 50000)) {
            return;
        }
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(50000);
        String errmsg = "<messages><message><messageString><![CDATA[ The following problem occurred: " + message + "]]</messageString></message></messages>";
        ind.setMessage(errmsg);
        traceLogger.log((Object)ind);
    }

    public static void fatalException(String message, Exception exception) {
        if (!IPFFunction.isEnabled(traceLogger, 50000)) {
            return;
        }
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(50000);
        String errmsg = "<messages><message><messageString><![CDATA[ The following problem occurred: " + message + " due to exception: " + exception.toString() + "]]</messageString></message></messages>";
        ind.setMessage(errmsg);
        traceLogger.log((Object)ind);
    }

    public static boolean isEnabled() {
        return IPFFunction.isEnabled(traceLogger, 10000);
    }

    public static void traceWithStack(String message) {
        if (!IPFTraceFunction.isEnabled()) {
            return;
        }
        Exception exception = new Exception();
        exception.fillInStackTrace();
        StringWriter stackWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stackWriter);
        exception.printStackTrace(pw);
        pw.flush();
        String callMethod = IPFFunction.getCaller(1);
        StringBuffer traceEntry = new StringBuffer("<trace>");
        traceEntry.append("<message");
        if (message == null) {
            traceEntry.append(">(NULL)</message>");
        } else if (message.length() == 0) {
            traceEntry.append("/>");
        } else {
            traceEntry.append("><![CDATA[" + callMethod + ": " + message + "]]></message>");
        }
        traceEntry.append("<stack><![CDATA[\n" + stackWriter.toString() + "]]></stack>");
        traceEntry.append("</trace>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(10000);
        ind.setMessage(traceEntry.toString());
        traceLogger.log((Object)ind);
    }

    public static void trace(String message) {
        if (!IPFTraceFunction.isEnabled()) {
            return;
        }
        String callMethod = IPFFunction.getCaller(1);
        StringBuffer traceEntry = new StringBuffer("<trace>");
        traceEntry.append("<message");
        if (message == null) {
            traceEntry.append(">(NULL)</message>");
        } else if (message.length() == 0) {
            traceEntry.append("/>");
        } else {
            traceEntry.append("><![CDATA[" + callMethod + ": " + message + "]]></message>");
        }
        traceEntry.append("</trace>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(10000);
        ind.setMessage(traceEntry.toString());
        traceLogger.log((Object)ind);
    }

    public void logEntry() {
        if (!IPFTraceFunction.isEnabled()) {
            return;
        }
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        super.logEntry((LogIndication)ind);
        ind.setLevel(10000);
        ind.setAction((byte)5);
        ind.setMessage(this.logData.toString());
        traceLogger.log((Object)ind);
    }

    public void logExit() {
        if (!IPFTraceFunction.isEnabled()) {
            return;
        }
        this.logExit("(void)", "void");
    }

    public void logExit(boolean returnValue) {
        if (!IPFTraceFunction.isEnabled()) {
            return;
        }
        this.logExit(returnValue ? "true" : "false", "boolean");
    }

    public void logExit(Exception thrownException) {
        if (!IPFTraceFunction.isEnabled()) {
            return;
        }
        StringWriter stackWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stackWriter);
        thrownException.printStackTrace(pw);
        pw.flush();
        this.logData.append("<exception><![CDATA[" + thrownException.toString() + "]]");
        this.logData.append("<stack><![CDATA[" + stackWriter.toString() + "]]</stack>");
        this.logData.append("</exception>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        super.logExit((LogIndication)ind);
        ind.setLevel(10000);
        ind.setAction((byte)6);
        ind.setMessage(this.logData.toString());
        traceLogger.log((Object)ind);
    }

    public void logExit(Object returnValue) {
        if (!IPFTraceFunction.isEnabled()) {
            return;
        }
        if (returnValue == null) {
            this.logExit(null, "");
        } else {
            this.logExit(returnValue.toString(), returnValue.getClass().getName());
        }
    }

    private void logExit(String returnValue, String type) {
        this.logData.append("<returnvalue");
        if (returnValue == null) {
            this.logData.append(">(NULL)</returnvalue>");
        } else if (returnValue.length() == 0) {
            this.logData.append("/>");
        } else {
            this.logData.append("><![CDATA[" + returnValue + "]]></returnvalue>");
        }
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        super.logExit((LogIndication)ind);
        ind.setLevel(10000);
        ind.setAction((byte)6);
        ind.setMessage(this.logData.toString());
        traceLogger.log((Object)ind);
    }

    static {
        try {
            if (IPFSwitch.isSwitchedOn()) {
                traceLogger = LogTypedLogger.getInstance((String)"Trace.CAM.JCAM", LogTraceIndication.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

