/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFFunction;
import com.cognos.accman.jcam.crypto.misc.IPFSwitch;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class IPFTraceLogger
extends IPFFunction {
    private LogTypedLogger traceLogger = null;
    private String theCallerMethod = null;

    public IPFTraceLogger(String loggerName) {
        try {
            if (IPFSwitch.isSwitchedOn()) {
                this.traceLogger = LogTypedLogger.getInstance((String)loggerName, LogTraceIndication.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isEnabled(int level) {
        return this.traceLogger != null && this.traceLogger.isEnabled(level);
    }

    public void fatalException(String message) {
        if (!this.isEnabled(50000)) {
            return;
        }
        this.theCallerMethod = IPFFunction.getCaller(1);
        this.resetLogData();
        this.logData.append("<function name=\"" + this.theCallerMethod + "\">");
        String errMessage = "<messages><message><messageString><![CDATA[ The following problem occurred: " + message + "]]</messageString></message></messages>";
        this.logData.append(errMessage);
        this.logData.append("</function>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(50000);
        ind.setMessage(this.logData.toString());
        this.traceLogger.log((Object)ind);
    }

    public void fatalException(String message, Exception exception) {
        if (!this.isEnabled(50000)) {
            return;
        }
        this.theCallerMethod = IPFFunction.getCaller(1);
        this.resetLogData();
        this.logData.append("<function name=\"" + this.theCallerMethod + "\">");
        String errMessage = "<messages><message><messageString><![CDATA[ The following problem occurred: " + message + " due to exception: " + exception.toString() + "]]</messageString></message></messages>";
        this.logData.append(errMessage);
        this.logData.append("</function>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(50000);
        ind.setMessage(this.logData.toString());
        this.traceLogger.log((Object)ind);
    }

    public void trace(String message) {
        if (!this.isEnabled(10000)) {
            return;
        }
        this.theCallerMethod = IPFFunction.getCaller(1);
        StringBuffer traceEntry = new StringBuffer("<trace>");
        traceEntry.append("<message");
        if (message == null) {
            traceEntry.append(">(NULL)</message>");
        } else if (message.length() == 0) {
            traceEntry.append("/>");
        } else {
            traceEntry.append("><![CDATA[" + this.theCallerMethod + ": " + message + "]]></message>");
        }
        traceEntry.append("</trace>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(10000);
        ind.setAction((byte)11);
        ind.setMessage(traceEntry.toString());
        this.traceLogger.log((Object)ind);
    }

    public void trace(String message, Exception exception) {
        if (!this.isEnabled(10000)) {
            return;
        }
        this.theCallerMethod = IPFFunction.getCaller(1);
        this.resetLogData();
        this.logData.append("<function name=\"" + this.theCallerMethod + "\">");
        String errMessage = "<messages><message><messageString><![CDATA[ The following problem occurred: " + message + " due to exception: " + exception.toString() + "]]</messageString></message></messages>";
        this.logData.append(errMessage);
        this.logData.append("</function>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(10000);
        ind.setAction((byte)11);
        ind.setMessage(this.logData.toString());
        this.traceLogger.log((Object)ind);
    }

    public void logEnter() {
        if (!this.isEnabled(10000)) {
            return;
        }
        this.theCallerMethod = IPFFunction.getCaller(1);
        this.resetLogData();
        this.logData.append("<function name=\"" + this.theCallerMethod + "\">");
        this.logData.append("<parameters>");
        this.logData.append("</parameters></function>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(10000);
        ind.setAction((byte)5);
        ind.setMessage(this.logData.toString());
        this.traceLogger.log((Object)ind);
    }

    public void logExit(Exception thrownException) {
        if (!this.isEnabled(10000)) {
            return;
        }
        this.theCallerMethod = IPFFunction.getCaller(1);
        this.resetLogData();
        this.logData.append("<function name=\"" + this.theCallerMethod + "\">");
        this.logData.append("<messages><message><messageString><![CDATA[" + thrownException.toString() + "]]</messageString></message></messages>");
        this.logData.append("</function>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        super.logExit((LogIndication)ind);
        ind.setLevel(10000);
        ind.setAction((byte)6);
        ind.setMessage(this.logData.toString());
        this.traceLogger.log((Object)ind);
    }

    public void logExit(String message, Exception exception) {
        if (!this.isEnabled(10000)) {
            return;
        }
        this.theCallerMethod = IPFFunction.getCaller(1);
        this.resetLogData();
        this.logData.append("<function name=\"" + this.theCallerMethod + "\">");
        String errMessage = "<messages><message><messageString><![CDATA[ The following problem occurred: " + message + " due to exception: " + exception.toString() + "]]</messageString></message></messages>";
        this.logData.append(errMessage);
        this.logData.append("</function>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(10000);
        ind.setAction((byte)11);
        ind.setMessage(this.logData.toString());
        this.traceLogger.log((Object)ind);
    }

    public void logExit(String returnValue) {
        if (!this.isEnabled(10000)) {
            return;
        }
        if (this.theCallerMethod == null) {
            this.theCallerMethod = IPFFunction.getCaller(1);
        }
        this.resetLogData();
        this.logData.append("<function name=\"" + this.theCallerMethod + "\">");
        this.logData.append("<parameters>");
        this.logData.append("<returnvalue");
        if (returnValue == null) {
            this.logData.append(">(NULL)</returnvalue>");
        } else if (returnValue.length() == 0) {
            this.logData.append("/>");
        } else {
            this.logData.append("><![CDATA[" + returnValue + "]]></returnvalue>");
        }
        this.logData.append("</parameters></function>");
        LogTraceIndication ind = new LogTraceIndication("jcam", IPFFunction.s_version);
        ind.setLevel(10000);
        ind.setAction((byte)6);
        ind.setMessage(this.logData.toString());
        this.traceLogger.log((Object)ind);
        this.resetCallerMethod();
    }

    public void logExit(boolean returnValue) {
        if (!this.isEnabled(10000)) {
            return;
        }
        this.theCallerMethod = IPFFunction.getCaller(1);
        this.logExit(returnValue ? "true" : "false");
    }

    public void logExit() {
        if (!this.isEnabled(10000)) {
            return;
        }
        this.theCallerMethod = IPFFunction.getCaller(1);
        this.logExit("(void)");
    }

    private void resetCallerMethod() {
        this.theCallerMethod = null;
    }

    public static void debugPrint(String message) {
        try {
            Thread currentThread = Thread.currentThread();
            String threadname = currentThread.toString();
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd 'at' H:mm:ss:SSS");
            String timenow = sdf.format(cal.getTime());
            String camcryptoDebugFile = ".." + File.separator + "logs" + File.separator + "camcrypto_deubg.log";
            FileOutputStream fos = new FileOutputStream(camcryptoDebugFile, true);
            PrintWriter pw = new PrintWriter(fos);
            pw.println(timenow + " " + threadname + " : " + message);
            pw.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public static String toBase64String(byte[] data) {
        if (data == null) {
            return String.valueOf(data);
        }
        return new String(CryptoWrapper.encodeBase64(data));
    }
}

