/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMSSLSocket;
import com.cognos.accman.jcam.crypto.misc.CAMSSLSocketFactory;
import com.cognos.accman.res.MessageSet;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class PKCS12JSSESSLSocketFactory
implements CAMSSLSocketFactory {
    private static SSLSocketFactory _jsf = null;

    public PKCS12JSSESSLSocketFactory(SSLSocketFactory jsf) {
        _jsf = jsf;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws CAMCryptoException {
        CAMSSLSocket s = null;
        try {
            if (_jsf == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_ssl_socket_factory"));
            }
            s = new CAMSSLSocket((SSLSocket)_jsf.createSocket(addr, port));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_ssl_socket_creation_failed"));
        }
        return s;
    }

    @Override
    public Socket createSocket(String addr, int port) throws CAMCryptoException {
        InetAddress host = null;
        try {
            host = InetAddress.getByName(addr);
        }
        catch (UnknownHostException e) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ssl_socket_creation_failed"));
        }
        return this.createSocket(host, port);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws CAMCryptoException {
        CAMSSLSocket s = null;
        try {
            if (_jsf == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_ssl_socket_factory"));
            }
            s = new CAMSSLSocket((SSLSocket)_jsf.createSocket(socket, host, port, autoClose));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_ssl_socket_creation_failed"));
        }
        return s;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws CAMCryptoException {
        CAMSSLSocket s = null;
        try {
            if (_jsf == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_ssl_socket_factory"));
            }
            s = new CAMSSLSocket((SSLSocket)_jsf.createSocket(host, port, clientHost, clientPort));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_ssl_socket_creation_failed"));
        }
        return s;
    }
}

