/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLContext;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SSLProtocolManager {
    final String jsseProvider;
    Map<Integer, SSLProtocol> camSupportedProtocols = new HashMap<Integer, SSLProtocol>();

    public SSLProtocolManager() throws CAMCryptoException {
        int order = 0;
        this.camSupportedProtocols.put(new Integer(order), new SSLProtocol(order, "TLS1.2", "TLSv1.2"));
        this.camSupportedProtocols.put(new Integer(++order), new SSLProtocol(order, "TLS1.1", "TLSv1.1"));
        this.camSupportedProtocols.put(new Integer(++order), new SSLProtocol(order, "TLS1.0", "TLSv1.0"));
        this.jsseProvider = JVMEnvironment.getInstance().getJSSEProviderName();
    }

    public Element getSupportedSSLProtocolsDOM() throws CAMCryptoException, IOException, NoSuchProviderException {
        Vector<SSLProtocol> vSSLProtocols = this.getSupportedSSLProtocols();
        Iterator<SSLProtocol> i = vSSLProtocols.iterator();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("values");
        while (i.hasNext()) {
            SSLProtocol protocol = i.next();
            root.addElement("enum").addAttribute("value", protocol.name).addAttribute("label", protocol.label).addAttribute("order", Integer.toString(protocol.order)).addAttribute("useLabel", new String("false"));
        }
        return document.getRootElement();
    }

    private Vector<SSLProtocol> getSupportedSSLProtocols() throws CAMCryptoException, IOException, NoSuchProviderException {
        Vector<SSLProtocol> supportedSSLProtocols = new Vector<SSLProtocol>();
        for (Map.Entry<Integer, SSLProtocol> entry : this.camSupportedProtocols.entrySet()) {
            SSLProtocol protocol = entry.getValue();
            try {
                SSLContext.getInstance(protocol.name, this.jsseProvider);
                supportedSSLProtocols.add(protocol);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return supportedSSLProtocols;
    }

    private static final class SSLProtocol {
        private final int order;
        private final String label;
        private final String name;

        private SSLProtocol(int theOrder, String theLabel, String theName) {
            this.order = theOrder;
            this.label = theLabel;
            this.name = theName;
        }
    }
}

