/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.objectpools;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.objectpools.ObjectPool;
import com.cognos.accman.res.MessageSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class DocumentBuilderPool
extends ObjectPool {
    private static final int MAX_STICKY = 10;
    private static DocumentBuilderPool instance = null;
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();

    public static synchronized DocumentBuilderPool getInstance() {
        if (instance == null) {
            instance = new DocumentBuilderPool();
        }
        return instance;
    }

    private DocumentBuilderPool() {
        super(10);
        this.docBuilderFactory.setNamespaceAware(true);
    }

    @Override
    Object create() throws CAMCryptoException {
        DocumentBuilder newDocBuilder;
        try {
            this.docBuilderFactory.setExpandEntityReferences(false);
            this.docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            newDocBuilder = this.docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pool_could_not_create_doc_builder"));
        }
        return newDocBuilder;
    }
}

