/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.objectpools;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.objectpools.PooledObject;
import com.cognos.accman.jcam.crypto.objectpools.SoftRefPooledObject;
import com.cognos.accman.jcam.crypto.objectpools.StickyPooledObject;
import java.util.ArrayList;

public abstract class ObjectPool {
    private ArrayList freeList = new ArrayList();
    private int stickyCount = 0;
    private int maxSticky;

    public ObjectPool(int maxSticky) {
        this.maxSticky = maxSticky;
    }

    abstract Object create() throws CAMCryptoException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PooledObject get() throws CAMCryptoException {
        PooledObject pooledObj = null;
        boolean createSticky = false;
        ArrayList arrayList = this.freeList;
        synchronized (arrayList) {
            while (!this.freeList.isEmpty()) {
                pooledObj = (PooledObject)this.freeList.remove(this.freeList.size() - 1);
                if (!pooledObj.isValid()) continue;
                return pooledObj;
            }
            if (this.stickyCount < this.maxSticky) {
                ++this.stickyCount;
                createSticky = true;
            }
        }
        if (createSticky) {
            return new StickyPooledObject(this.create(), this);
        }
        return new SoftRefPooledObject(this.create(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releasePooledObject(PooledObject pooledObj) {
        ArrayList arrayList = this.freeList;
        synchronized (arrayList) {
            this.freeList.add(pooledObj);
        }
    }
}

