/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.objectpools;

import com.cognos.accman.jcam.crypto.objectpools.ObjectPool;
import com.cognos.accman.jcam.crypto.objectpools.PooledObject;
import java.lang.ref.SoftReference;

public class SoftRefPooledObject
extends PooledObject {
    private SoftReference softRefToPooledObject;
    private Object hardRefToPooledObject;

    SoftRefPooledObject(Object pooledObject, ObjectPool pool) {
        super(pool);
        this.softRefToPooledObject = new SoftReference<Object>(pooledObject);
        this.hardRefToPooledObject = pooledObject;
    }

    @Override
    public boolean isValid() {
        if (this.hardRefToPooledObject != null) {
            return true;
        }
        return this.softRefToPooledObject.get() != null;
    }

    @Override
    public Object getObject() {
        if (this.hardRefToPooledObject != null) {
            return this.hardRefToPooledObject;
        }
        return this.softRefToPooledObject.get();
    }

    @Override
    public void release() {
        this.hardRefToPooledObject = null;
        super.release();
    }
}

