/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pdf;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    public static final int PERMISSION_PRINT = 4;
    public static final int PERMISSION_EDIT_CONTENT = 8;
    public static final int PERMISSION_COPY_CONTENT = 16;
    public static final int PERMISSION_EDIT_ANNOTATIONS = 32;
    private MessageDigest digest = null;
    private Cipher cipherRC4 = null;
    private Cipher cipherAES = null;
    private Cipher encryptcipher = null;
    private int keylength = 5;
    private int revision = 4;
    public static final byte[] pad = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final byte[] meta = new byte[]{-1, -1, -1, -1};
    private String userPassword = "";
    private String ownerPassword = "";
    private byte[] oValue = null;
    private byte[] uValue = null;
    private byte[] encryptionKey = null;
    private boolean allowPrint = true;
    private boolean allowCopyContent = true;
    private boolean allowEditContent = true;
    private boolean allowEditAnnotations = true;
    private int permissions = -4;
    byte[] fileId = null;
    private boolean encryptMetadata = false;

    public Encryption() throws CAMCryptoException {
        Configuration cnfg = Configuration.getInstance();
        String alg = cnfg.getPDFEncryptionAlgorithm();
        int keysize = cnfg.getPDFKeySizeInBytes();
        this.setKeyLength(keysize);
        String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
        try {
            this.digest = MessageDigest.getInstance("MD5", jceProvider);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_no_md5"));
        }
        try {
            this.cipherRC4 = Cipher.getInstance("RC4", jceProvider);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_no_rc4"));
        }
        if (alg.compareTo("AES") == 0) {
            try {
                this.encryptcipher = this.cipherAES = Cipher.getInstance("AES", jceProvider);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_no_aes"));
            }
            catch (NoSuchPaddingException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_no_aespadding"));
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_provider_check_error"));
            }
        } else {
            this.encryptcipher = this.cipherRC4;
        }
    }

    public byte[] encrypt(byte[] plaintext, int object, int generation) throws CAMCryptoException {
        if (this.digest == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_digest_not_initialized"));
        }
        if (this.encryptcipher == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_encryption_cipher_not_initialized"));
        }
        if (this.encryptionKey == null) {
            this.createEncryptionkey(this.encryptionKey);
        }
        byte[] hash = new byte[this.encryptionKey.length + 5];
        System.arraycopy(this.encryptionKey, 0, hash, 0, this.encryptionKey.length);
        int i = this.encryptionKey.length;
        hash[i++] = (byte)(object >>> 0);
        hash[i++] = (byte)(object >>> 8);
        hash[i++] = (byte)(object >>> 16);
        hash[i++] = (byte)(generation >>> 0);
        hash[i++] = (byte)(generation >>> 8);
        this.digest.reset();
        byte[] step3 = this.digest.digest(hash);
        int length = Math.min(hash.length, 16);
        byte[] step4key = new byte[length];
        System.arraycopy(step3, 0, step4key, 0, length);
        Configuration cnfg = Configuration.getInstance();
        String encryptAlgorithm = cnfg.getPDFEncryptionAlgorithm();
        int keysize = cnfg.getPDFKeySizeInBytes();
        SecretKeySpec keyspecStep4 = new SecretKeySpec(step4key, 0, keysize, encryptAlgorithm);
        byte[] ciphertext = null;
        try {
            this.encryptcipher.init(1, keyspecStep4);
            ciphertext = this.encryptcipher.doFinal(plaintext);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_ovalue_step7"));
        }
        return ciphertext;
    }

    public byte[] createOvalue() throws CAMCryptoException {
        byte[] step2;
        if (this.revision == 2 && this.keylength != 5) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_invalid_keylenth_for_revision"));
        }
        if (this.digest == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_digest_not_initialized"));
        }
        if (this.cipherRC4 == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_rc4_not_initialized"));
        }
        byte[] step1 = null;
        step1 = this.ownerPassword.length() > 0 ? this.padtruncPassword(this.ownerPassword) : this.padtruncPassword(this.userPassword);
        this.digest.reset();
        byte[] step3 = step2 = this.digest.digest(step1);
        if (this.revision >= 3) {
            for (int i = 0; i < 50; ++i) {
                this.digest.reset();
                step3 = this.digest.digest(step3);
            }
        }
        SecretKeySpec keyspecStep4 = null;
        byte[] step4key = null;
        if (this.revision >= 3) {
            step4key = new byte[this.keylength];
            System.arraycopy(step3, 0, step4key, 0, this.keylength);
            keyspecStep4 = new SecretKeySpec(step4key, "RC4");
        } else if (this.revision == 2) {
            step4key = new byte[5];
            System.arraycopy(step3, 0, step4key, 0, 5);
            keyspecStep4 = new SecretKeySpec(step4key, "RC4");
        }
        byte[] step5 = this.padtruncPassword(this.userPassword);
        byte[] step6 = null;
        try {
            this.cipherRC4.init(1, keyspecStep4);
        }
        catch (InvalidKeyException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_ovalue_step6_badkey"));
        }
        try {
            step6 = this.cipherRC4.doFinal(step5);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_ovalue_step6"));
        }
        byte[] step7 = step6;
        if (this.revision >= 3) {
            byte[] iterKey = new byte[this.keylength];
            for (int i = 1; i <= 19; ++i) {
                System.arraycopy(step4key, 0, iterKey, 0, step4key.length);
                for (int j = 0; j < step4key.length; ++j) {
                    iterKey[j] = (byte)(iterKey[j] ^ (byte)i);
                }
                SecretKeySpec keyspecStep7 = new SecretKeySpec(iterKey, "RC4");
                try {
                    this.cipherRC4.init(1, keyspecStep7);
                    step7 = this.cipherRC4.doFinal(step7);
                    continue;
                }
                catch (Exception e) {
                    throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_ovalue_step7"));
                }
            }
        }
        this.oValue = step7;
        return this.oValue;
    }

    public byte[] createUvalue() throws CAMCryptoException {
        if (this.digest == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_digest_not_initialized"));
        }
        if (this.cipherRC4 == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_rc4_not_initialized"));
        }
        byte[] finalResult = new byte[32];
        if (this.revision == 2 && this.keylength != 40) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_invalid_keylenth_for_revision"));
        }
        byte[] encryptionkey = this.createEncryptionKey(this.userPassword);
        if (this.revision >= 3) {
            this.digest.reset();
            this.digest.update(pad);
            this.digest.update(this.fileId);
            byte[] step3 = this.digest.digest();
            byte[] step4 = null;
            try {
                SecretKeySpec keyspecStep4 = new SecretKeySpec(encryptionkey, "RC4");
                this.cipherRC4.init(1, keyspecStep4);
                step4 = this.cipherRC4.doFinal(step3);
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_uvalue_step4"));
            }
            byte[] step5 = step4;
            for (int i = 1; i < 20; ++i) {
                byte[] iterationKey = new byte[this.encryptionKey.length];
                System.arraycopy(this.encryptionKey, 0, iterationKey, 0, iterationKey.length);
                for (int j = 0; j < iterationKey.length; ++j) {
                    iterationKey[j] = (byte)(iterationKey[j] ^ i);
                }
                try {
                    SecretKeySpec keyspecStep5 = new SecretKeySpec(iterationKey, "RC4");
                    this.cipherRC4.init(1, keyspecStep5);
                    step5 = this.cipherRC4.doFinal(step5);
                    continue;
                }
                catch (Exception e) {
                    throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_uvalue_step5"));
                }
            }
            System.arraycopy(step5, 0, finalResult, 0, 16);
            System.arraycopy(pad, 0, finalResult, 16, 16);
            this.uValue = finalResult;
        } else if (this.revision == 2) {
            try {
                SecretKeySpec keyspecStep2 = new SecretKeySpec(encryptionkey, "RC4");
                this.cipherRC4.init(1, keyspecStep2);
                finalResult = this.cipherRC4.doFinal(pad);
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pdfencrypt_uvalue_step2"));
            }
            this.uValue = finalResult;
        }
        return this.uValue;
    }

    public byte[] createEncryptionkey(byte[] password) throws CAMCryptoException {
        String szPassword = new String(password);
        return this.createEncryptionKey(szPassword);
    }

    public byte[] createEncryptionKey(String password) throws CAMCryptoException {
        byte[] step7;
        if (this.revision == 2 && this.keylength != 40) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_invalid_keylenth_for_revision"));
        }
        if (this.digest == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_digest_not_initialized"));
        }
        if (this.cipherRC4 == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_rc4_not_initialized"));
        }
        byte[] step1 = null;
        step1 = this.padtruncPassword(password);
        this.digest.reset();
        this.digest.update(step1);
        this.digest.update(this.oValue);
        byte zero = (byte)(this.permissions >>> 0);
        byte one = (byte)(this.permissions >>> 8);
        byte two = (byte)(this.permissions >>> 16);
        byte three = (byte)(this.permissions >>> 24);
        this.digest.update(zero);
        this.digest.update(one);
        this.digest.update(two);
        this.digest.update(three);
        this.digest.update(this.fileId[0]);
        if (!this.encryptMetadata) {
            this.digest.update(meta);
        }
        byte[] step8 = step7 = this.digest.digest();
        if (this.revision > 3) {
            for (int i = 0; i < 50; ++i) {
                this.digest.reset();
                this.digest.update(step8, 0, this.keylength);
                step8 = this.digest.digest();
            }
        }
        System.arraycopy(this.digest, 0, this.encryptionKey, 0, this.keylength);
        return this.encryptionKey;
    }

    private byte[] padtruncPassword(String password) throws CAMCryptoException {
        int i;
        byte[] result = new byte[32];
        byte[] pbuffer = null;
        pbuffer = password == null || password.length() == 0 ? new byte[]{} : password.getBytes();
        int j = 0;
        for (i = 0; i < result.length && i < pbuffer.length; ++i) {
            result[i] = pbuffer[i];
        }
        while (i < result.length) {
            result[i++] = pad[j++];
        }
        return result;
    }

    public void setUserPassword(String userPassword) {
        if (userPassword != null) {
            this.userPassword = userPassword;
        }
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setOwnerPassword(String ownerPassword) {
        if (ownerPassword != null) {
            this.ownerPassword = ownerPassword;
        }
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    private void setKeyLength(int keylength) throws CAMCryptoException {
        if (keylength < 5 || keylength > 16) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pdfencrypt_invalid_keylength"));
        }
        this.keylength = keylength;
    }

    public int getKeyLength() {
        return this.keylength;
    }

    private void setupPermissions() {
        this.permissions = -4;
        if (!this.allowPrint) {
            this.permissions -= 4;
        }
        if (!this.allowCopyContent) {
            this.permissions -= 16;
        }
        if (!this.allowEditContent) {
            this.permissions -= 8;
        }
        if (!this.allowEditAnnotations) {
            this.permissions -= 32;
        }
    }

    public void setAllowPrint(boolean value) {
        this.allowPrint = value;
    }

    public void setAllowCopyContent(boolean value) {
        this.allowCopyContent = value;
        this.setupPermissions();
    }

    public void setAllowEditContent(boolean value) {
        this.allowEditContent = value;
        this.setupPermissions();
    }

    public void setAllowEditAnnotation(boolean value) {
        this.allowEditAnnotations = value;
        this.setupPermissions();
    }

    public void setEncryptMetadata(boolean value) {
        this.encryptMetadata = value;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setFileId(byte[] id) {
        this.fileId = id;
    }
}

