/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

class EncryptedContentInfoGenerator {
    static final int CURRENT_CSK_PLAINTEXT_ENCODING_VERSION = 1;

    EncryptedContentInfoGenerator() {
    }

    public static EncryptedContentInfo generate(Cipher cipher, byte[] content, String algId, int effectiveKeySize) throws CAMCryptoException {
        DEROctetString ec;
        ASN1Primitive params = null;
        try {
            AlgorithmParameters algParams = cipher.getParameters();
            if (algParams != null) {
                byte[] encodedParams = algParams.getEncoded("ASN.1");
                ByteArrayInputStream baos = new ByteArrayInputStream(encodedParams);
                ASN1InputStream dis = new ASN1InputStream((InputStream)baos);
                params = dis.readObject();
            }
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        ASN1ObjectIdentifier contentType = new ASN1ObjectIdentifier("1.2.840.113549.1.7.1");
        AlgorithmIdentifier cea = params != null ? new AlgorithmIdentifier(new ASN1ObjectIdentifier(algId), params) : new AlgorithmIdentifier(new ASN1ObjectIdentifier(algId));
        try {
            ec = new DEROctetString(cipher.doFinal(content));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        return new EncryptedContentInfo(contentType, cea, (ASN1OctetString)ec);
    }

    public static EncryptedContentInfo generateUsingCSK(Cipher cipher, byte[] content, String algId, SecretKey csk) throws CAMCryptoException {
        DEROctetString ec;
        ASN1Primitive params = null;
        try {
            AlgorithmParameters algParams = cipher.getParameters();
            if (algParams != null) {
                byte[] encodedParams = algParams.getEncoded("ASN.1");
                ByteArrayInputStream baos = new ByteArrayInputStream(encodedParams);
                ASN1InputStream dis = new ASN1InputStream((InputStream)baos);
                params = dis.readObject();
            }
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        ASN1ObjectIdentifier contentType = new ASN1ObjectIdentifier("1.2.840.113549.1.7.1");
        AlgorithmIdentifier cea = params != null ? new AlgorithmIdentifier(new ASN1ObjectIdentifier(algId), params) : new AlgorithmIdentifier(new ASN1ObjectIdentifier(algId));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] ptheader = new byte[]{0, 67, 65, 77, 0};
            baos.write(ptheader);
            baos.write(1);
            int randomdatalen = cipher.getBlockSize() > 0 ? cipher.getBlockSize() : 8;
            baos.write((byte)randomdatalen);
            SecureRandom random = JVMEnvironment.getInstance().getSecureRandom();
            byte[] randbytes = new byte[randomdatalen];
            random.nextBytes(randbytes);
            baos.write(randbytes);
            baos.write(content);
            byte[] cskHash = CAMCryptoUtilities.digestCSK(csk);
            byte[] encContent = cipher.doFinal(baos.toByteArray());
            try {
                baos = new ByteArrayOutputStream();
                baos.write(cskHash);
                baos.write(encContent);
            }
            catch (IOException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
            }
            ec = new DEROctetString(baos.toByteArray());
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        return new EncryptedContentInfo(contentType, cea, (ASN1OctetString)ec);
    }
}

