/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.EncodedCSK;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.pkcs.DecryptionResult;
import com.cognos.accman.jcam.crypto.pkcs.EncryptedContentInfoGenerator;
import com.cognos.accman.jcam.crypto.pkcs.EncryptedContentInfoParser;
import com.cognos.accman.jcam.crypto.pkcs.EncryptionResult;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PKCS7EncryptedData {
    public static byte[] encode(SecretKey key, byte[] plaintext) throws CAMCryptoException {
        EncryptionResult result = PKCS7EncryptedData.getEncryptionResult(key, plaintext);
        return result.getEncryptedData();
    }

    public static EncryptionResult getEncryptionResult(SecretKey key, byte[] plaintext) throws CAMCryptoException {
        try {
            String alg = EncodedCSK.lookupAlg(key);
            String algOid = "";
            if (alg.equalsIgnoreCase("AES")) {
                alg = "AES/CBC/PKCS5Padding";
                int keySize = key.getEncoded().length * 8;
                if (keySize == 128) {
                    algOid = "2.16.840.1.101.3.4.1.2";
                } else if (keySize == 256) {
                    algOid = "2.16.840.1.101.3.4.1.42";
                } else {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{"key size = " + Integer.toString(keySize)}));
                }
            }
            if (alg.equalsIgnoreCase("DES")) {
                alg = "DES/CBC/PKCS5Padding";
                algOid = "1.3.14.3.2.7";
            } else if (alg.equalsIgnoreCase("DESede")) {
                alg = "DESede/CBC/PKCS5Padding";
                algOid = "1.2.840.113549.3.7";
            } else if (alg.equalsIgnoreCase("RC2")) {
                alg = "RC2/CBC/PKCS5Padding";
                algOid = "1.2.840.113549.3.2";
            } else if (alg.equalsIgnoreCase("RC4")) {
                alg = "RC4";
                algOid = "1.2.840.113549.3.4";
            }
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            Cipher cipher = Cipher.getInstance(alg, jceProvider);
            cipher.init(1, key);
            EncryptedContentInfo data = EncryptedContentInfoGenerator.generateUsingCSK(cipher, plaintext, algOid, key);
            ASN1EncodableVector encDataVector = new ASN1EncodableVector();
            encDataVector.add((ASN1Encodable)new DERInteger(BigInteger.ZERO));
            encDataVector.add((ASN1Encodable)data);
            DERSequence encDataWrapper = new DERSequence(encDataVector);
            ContentInfo contentInfo = new ContentInfo(new ASN1ObjectIdentifier("1.2.840.113549.1.7.6"), (ASN1Encodable)encDataWrapper);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream dos = new DEROutputStream((OutputStream)baos);
            dos.writeObject((ASN1Encodable)contentInfo);
            return new EncryptionResult(cipher, baos.toByteArray());
        }
        catch (NoSuchProviderException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        catch (NoSuchPaddingException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{"DES/CBC/PKCS5Padding"}));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{"DES/CBC/PKCS5Padding"}));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
    }

    public static byte[] decode(byte[] data) throws CAMCryptoException {
        DecryptionResult result = PKCS7EncryptedData.getDecryptionResult(data);
        return result.getPlainText();
    }

    public static DecryptionResult getDecryptionResult(byte[] data) throws CAMCryptoException {
        if (data.length > 0) {
            ASN1InputStream dis = null;
            try {
                dis = new ASN1InputStream((InputStream)new ByteArrayInputStream(data));
            }
            catch (IndexOutOfBoundsException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_decode_data_bad"));
            }
            try {
                ASN1Primitive pkcs = dis.readObject();
                ContentInfo contentInfo = ContentInfo.getInstance((Object)pkcs);
                String ct = contentInfo.getContentType().getId();
                if (!ct.equals("1.2.840.113549.1.7.6")) {
                    throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_invalid_type", new String[]{ct}));
                }
                ASN1Sequence encDataWrapper = (ASN1Sequence)contentInfo.getContent();
                if (!(encDataWrapper.getObjectAt(0) instanceof ASN1Integer)) {
                    throw new CAMCryptoException("CAM_CRP_pkcs7_decode");
                }
                EncryptedContentInfo d = null;
                DERSequence encContentInfo = (DERSequence)encDataWrapper.getObjectAt(1);
                if (encContentInfo.size() == 2) {
                    ASN1Sequence algorithmIdentifierSequence = (ASN1Sequence)encContentInfo.getObjectAt(0);
                    ASN1ObjectIdentifier algorithmIdentifier_oid = (ASN1ObjectIdentifier)algorithmIdentifierSequence.getObjectAt(0);
                    ASN1Encodable algorithmIdentifier_params = algorithmIdentifierSequence.getObjectAt(1);
                    AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(algorithmIdentifier_oid, algorithmIdentifier_params);
                    DERTaggedObject encryptedContent_taggedObject = (DERTaggedObject)encContentInfo.getObjectAt(1);
                    DEROctetString encryptedContent = (DEROctetString)encryptedContent_taggedObject.getObject();
                    d = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algorithmIdentifier, (ASN1OctetString)encryptedContent);
                } else {
                    d = EncryptedContentInfo.getInstance((Object)encContentInfo);
                }
                return EncryptedContentInfoParser.getDecryptionResultUsingCSK(d);
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
            }
        }
        throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_decode_no_data"));
    }
}

