/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.pkcs.EnvelopedDataGenerator;
import com.cognos.accman.jcam.crypto.pkcs.EnvelopedDataParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;

public class PKCS7EnvelopedData {
    public static byte[] encode(X509Certificate[] recipients, byte[] plaintext) throws CAMCryptoException {
        try {
            EnvelopedDataGenerator generator = new EnvelopedDataGenerator();
            generator.addRecipients(recipients);
            generator.setContent(plaintext);
            EnvelopedData data = generator.generate();
            ContentInfo contentInfo = new ContentInfo(new ASN1ObjectIdentifier("1.2.840.113549.1.7.3"), (ASN1Encodable)data);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream dos = new DEROutputStream((OutputStream)baos);
            dos.writeObject((ASN1Encodable)contentInfo);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, "CAM-CRP-XXX error encoding enveloped data");
        }
    }

    public static byte[] decode(byte[] data) throws CAMCryptoException {
        try {
            ASN1InputStream dis = new ASN1InputStream((InputStream)new ByteArrayInputStream(data));
            ASN1Primitive pkcs = dis.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance((Object)pkcs);
            if (!contentInfo.getContentType().getId().equals(CMSObjectIdentifiers.envelopedData.getId())) {
                throw new CAMCryptoException("CAM-CRP-XXX invalid content type");
            }
            EnvelopedData d = EnvelopedData.getInstance((Object)contentInfo.getContent());
            return EnvelopedDataParser.getData(d);
        }
        catch (CAMCryptoException e) {
            e.fillInStackTrace();
            throw e;
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, "CAM-CRP-XXX error decoding enveloped data");
        }
    }
}

