/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.pkcs.SignedDataGenerator;
import com.cognos.accman.jcam.crypto.pkcs.SignedDataParser;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.SignedData;

public class PKCS7SignedData {
    public static byte[] sign(byte[] inputData, PrivateKey privateKey, X509Certificate[] certChain, String hashAlgorithm) throws CAMCryptoException {
        try {
            SignedDataGenerator generator = new SignedDataGenerator();
            SignedData data = generator.generate(inputData, privateKey, certChain, hashAlgorithm);
            ContentInfo contentInfo = new ContentInfo(new ASN1ObjectIdentifier("1.2.840.113549.1.7.2"), (ASN1Encodable)data);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream dos = new DEROutputStream((OutputStream)baos);
            dos.writeObject((ASN1Encodable)contentInfo);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
    }

    public static byte[] verify(SignedData signedDataObject) throws CAMCryptoException {
        try {
            return SignedDataParser.verify(signedDataObject);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
    }

    public static byte[] getContentData(SignedData signedDataObject) throws CAMCryptoException {
        byte[] contentData = SignedDataParser.getConetentData(signedDataObject);
        return contentData;
    }

    public static SignedData getSignedContentDataObject(byte[] signedData) throws IOException, CAMCryptoException {
        ASN1InputStream dis = new ASN1InputStream((InputStream)new ByteArrayInputStream(signedData));
        ASN1Primitive pkcs = dis.readObject();
        ContentInfo contentInfo = ContentInfo.getInstance((Object)pkcs);
        String type = contentInfo.getContentType().getId();
        if (!type.equals("1.2.840.113549.1.7.2")) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_invalid_type", new String[]{type}));
        }
        SignedData signedDataObject = SignedData.getInstance((Object)contentInfo.getContent());
        return signedDataObject;
    }
}

