/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

class RecipientInfoGenerator {
    RecipientInfoGenerator() {
    }

    public static ASN1Set generate(X509Certificate[] recipientCerts, SecretKey key) throws CAMCryptoException {
        ASN1EncodableVector recipients = new ASN1EncodableVector();
        String asymmKeystoreProvider = Configuration.getInstance().getAsymmKeystoreProviderName();
        for (int i = 0; i < recipientCerts.length; ++i) {
            DEROctetString encryptedKey;
            AlgorithmIdentifier keyEncAlgID;
            RecipientIdentifier recipientIdentifier;
            try {
                X500Name issuer = CAMCryptoUtilities.getIssuerDNAsX500Name(recipientCerts[i]);
                BigInteger serialNumber = recipientCerts[i].getSerialNumber();
                recipientIdentifier = new RecipientIdentifier(new IssuerAndSerialNumber(issuer, serialNumber));
                keyEncAlgID = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.1"));
                Cipher cipher = null;
                if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                    String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                    cipher = Cipher.getInstance("RSA", jceProvider);
                } else {
                    cipher = Cipher.getInstance("RSA", asymmKeystoreProvider);
                }
                cipher.init(1, recipientCerts[i].getPublicKey());
                encryptedKey = new DEROctetString(cipher.doFinal(key.getEncoded()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{"RSA"}));
            }
            catch (NoSuchPaddingException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{"RSA"}));
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
            }
            recipients.add((ASN1Encodable)new RecipientInfo(new KeyTransRecipientInfo(recipientIdentifier, keyEncAlgID, (ASN1OctetString)encryptedKey)));
        }
        return new DERSet(recipients);
    }
}

