/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.res.MessageSet;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x500.X500Name;

class RecipientInfosParser {
    RecipientInfosParser() {
    }

    public static byte[] getSecretKeyBytes(ASN1Set infos) throws CAMCryptoException {
        Enumeration recipients = infos.getObjects();
        while (recipients.hasMoreElements()) {
            PrivateKey key;
            RecipientInfo ri = RecipientInfo.getInstance(recipients.nextElement());
            ASN1Encodable o = ri.getInfo();
            if (!(o instanceof KeyTransRecipientInfo)) continue;
            KeyTransRecipientInfo recipient = (KeyTransRecipientInfo)o;
            IssuerAndSerialNumber r_ias = (IssuerAndSerialNumber)recipient.getRecipientIdentifier().getId();
            X500Name r_issuer = r_ias.getName();
            BigInteger r_serialNumber = r_ias.getSerialNumber().getValue();
            try {
                key = KeyStoreReader.getEncryptionPrivateKey(r_issuer, r_serialNumber);
            }
            catch (CAMCryptoException e) {
                continue;
            }
            return RecipientInfosParser.getSecretKeyBytes(recipient, key);
        }
        throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_recipient_not_found"));
    }

    private static byte[] getSecretKeyBytes(KeyTransRecipientInfo recipient, PrivateKey key) throws CAMCryptoException {
        String algId = recipient.getKeyEncryptionAlgorithm().getAlgorithm().getId();
        String asymmKeystoreProvider = Configuration.getInstance().getAsymmKeystoreProviderName();
        try {
            if (algId.equals("1.2.840.113549.1.1.1")) {
                Cipher cipher = null;
                if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                    String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                    cipher = Cipher.getInstance("RSA", jceProvider);
                } else {
                    cipher = Cipher.getInstance("RSA", asymmKeystoreProvider);
                }
                cipher.init(2, key);
                return cipher.doFinal(recipient.getEncryptedKey().getOctets());
            }
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{algId}));
        }
        catch (InvalidKeyException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{"RSA"}));
        }
        catch (NoSuchPaddingException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{"RSA"}));
        }
        catch (IllegalBlockSizeException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        catch (BadPaddingException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        catch (NoSuchProviderException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
    }
}

