/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;

class SignedDataGenerator {
    SignedDataGenerator() {
    }

    public SignedData generate(byte[] inputData, PrivateKey privKey, X509Certificate[] certChain, String hashAlgorithm) throws CAMCryptoException {
        String signAlgorithm = null;
        try {
            Configuration config = Configuration.getInstance();
            String asymmKeystoreProvider = config.getAsymmKeystoreProviderName();
            String digestEncryptionAlgorithm = privKey.getAlgorithm();
            signAlgorithm = Configuration.getSignatureAlgorithm(hashAlgorithm, digestEncryptionAlgorithm);
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            Signature signature = null;
            signature = JVMEnvironment.getInstance().isFIPSEnabled() ? Signature.getInstance(signAlgorithm, jceProvider) : Signature.getInstance(signAlgorithm, asymmKeystoreProvider);
            signature.initSign(privKey);
            signature.update(inputData);
            byte[] digest = signature.sign();
            int version = 1;
            String digestAlgorithmOID = this.getOID(hashAlgorithm);
            HashSet<String> digestalgos = new HashSet<String>();
            digestalgos.add(digestAlgorithmOID);
            ASN1EncodableVector algosVector = new ASN1EncodableVector();
            Iterator i = digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new ASN1ObjectIdentifier((String)i.next()), null);
                algosVector.add((ASN1Encodable)a);
            }
            DERSet algos = new DERSet(algosVector);
            ContentInfo cinfo = new ContentInfo(new ASN1ObjectIdentifier("1.2.840.113549.1.7.1"), (ASN1Encodable)new DEROctetString(inputData));
            ASN1Primitive contentinfo = cinfo.toASN1Primitive();
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            for (int i2 = 0; i2 < certChain.length; ++i2) {
                certs.add(certChain[i2]);
            }
            X509Certificate signCert = certChain[0];
            String digestEncryptionAlgorithmOID = this.getOID(digestEncryptionAlgorithm);
            ASN1EncodableVector certsVector = new ASN1EncodableVector();
            Iterator i3 = certs.iterator();
            while (i3.hasNext()) {
                ASN1InputStream tempstream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509Certificate)i3.next()).getEncoded()));
                certsVector.add((ASN1Encodable)tempstream.readObject());
            }
            DERSet dercertificates = new DERSet(certsVector);
            DEREncodableVector signerinfo = new DEREncodableVector();
            int signerversion = 1;
            signerinfo.add((ASN1Encodable)new DERInteger((long)signerversion));
            TBSCertificateStructure tbsCert = TBSCertificateStructure.getInstance((Object)ASN1Primitive.fromByteArray((byte[])signCert.getTBSCertificate()));
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(X509Name.getInstance((Object)tbsCert.getIssuer()), (ASN1Integer)new DERInteger(signCert.getSerialNumber()));
            signerinfo.add((ASN1Encodable)isAnds);
            signerinfo.add((ASN1Encodable)new AlgorithmIdentifier(new ASN1ObjectIdentifier(digestAlgorithmOID), null));
            signerinfo.add((ASN1Encodable)new AlgorithmIdentifier(new ASN1ObjectIdentifier(digestEncryptionAlgorithmOID), null));
            signerinfo.add((ASN1Encodable)new DEROctetString(digest));
            DEREncodableVector body = new DEREncodableVector();
            body.add((ASN1Encodable)new DERInteger((long)version));
            body.add((ASN1Encodable)algos);
            body.add((ASN1Encodable)contentinfo);
            body.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)dercertificates));
            DEREncodableVector signerinfos = new DEREncodableVector();
            signerinfos.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)signerinfo));
            body.add((ASN1Encodable)new DERSet((ASN1EncodableVector)signerinfos));
            return new SignedData((ASN1Sequence)new DERSequence((ASN1EncodableVector)body));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{signAlgorithm}));
        }
        catch (NoSuchProviderException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        catch (CertificateEncodingException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        catch (InvalidKeyException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        catch (SignatureException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
    }

    private String getOID(String algorithName) throws CAMCryptoException {
        if (algorithName.equals("MD5")) {
            return "1.2.840.113549.2.5";
        }
        if (algorithName.equals("MD2")) {
            return "1.2.840.113549.2.2";
        }
        if (algorithName.equals("SHA")) {
            return "1.3.14.3.2.26";
        }
        if (algorithName.equals("SHA1")) {
            return "1.3.14.3.2.26";
        }
        if (algorithName.equals("SHA-1")) {
            return "1.3.14.3.2.26";
        }
        if (algorithName.equals("SHA256")) {
            return "2.16.840.1.101.3.4.2.1";
        }
        if (algorithName.equals("SHA-256")) {
            return "2.16.840.1.101.3.4.2.1";
        }
        if (algorithName.equals("SHA384")) {
            return "2.16.840.1.101.3.4.2.2";
        }
        if (algorithName.equals("SHA-384")) {
            return "2.16.840.1.101.3.4.2.2";
        }
        if (algorithName.equals("SHA512")) {
            return "2.16.840.1.101.3.4.2.3";
        }
        if (algorithName.equals("SHA-512")) {
            return "2.16.840.1.101.3.4.2.3";
        }
        if (algorithName.equals("DSA")) {
            return "1.2.840.10040.4.1";
        }
        if (algorithName.equals("RSA")) {
            return "1.2.840.113549.1.1.1";
        }
        throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_invalid_alg", new String[]{algorithName}));
    }
}

