/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;

class SignedDataParser {
    SignedDataParser() {
    }

    public static byte[] verify(SignedData data) throws CAMCryptoException {
        String signAlgorithm = null;
        try {
            byte[] contentData = null;
            byte[] inputData = SignedDataParser.getConetentData(data);
            DERSet signerinfos = (DERSet)data.getSignerInfos();
            if (data.getCertificates() == null) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_no_cert"));
            }
            SignerInfo signerInfo = SignerInfo.getInstance((Object)signerinfos.getObjectAt(0));
            int signerversion = signerInfo.getVersion().getValue().intValue();
            IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
            BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
            X500Name issuer = isAnds.getName();
            boolean found = false;
            ASN1Set certs = data.getCertificates();
            X509Certificate x509SigningCert = null;
            int nCerts = certs.size();
            X509Certificate x509Cert = null;
            HashMap<Principal, X509Certificate> issuerCertMap = new HashMap<Principal, X509Certificate>();
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                for (int i = 0; i < nCerts; ++i) {
                    ASN1Sequence asn1SegCert = ASN1Sequence.getInstance((Object)certs.getObjectAt(i));
                    X509CertificateHolder cert = new X509CertificateHolder(asn1SegCert.getEncoded());
                    ByteArrayInputStream in = new ByteArrayInputStream(cert.getEncoded());
                    x509Cert = (X509Certificate)certFactory.generateCertificate(in);
                    if (cert.getSerialNumber().equals(serialNumber) && cert.getIssuer().equals((Object)issuer)) {
                        x509SigningCert = x509Cert;
                        found = true;
                        continue;
                    }
                    issuerCertMap.put(x509Cert.getSubjectDN(), x509Cert);
                }
            }
            catch (CertificateException ce) {
                throw new CAMCryptoException(ce, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
            }
            catch (IOException ioe) {
                throw new CAMCryptoException(ioe, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
            }
            if (!found) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_cert_sn_not_found", new String[]{serialNumber.toString(16)}));
            }
            if (nCerts == 1) {
                KeyStoreReader.verifyCertificateIsTrusted(x509Cert, true);
            } else {
                X509Certificate[] x509CertArray = SignedDataParser.buildX509CertChain(x509SigningCert, issuerCertMap);
                KeyStoreReader.verifyCertificateChainIsTrusted(x509CertArray, true);
            }
            byte[] digest = signerInfo.getEncryptedDigest().getOctets();
            String digestAlgorithm = signerInfo.getDigestAlgorithm().getAlgorithm().getId();
            String digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm().getId();
            signAlgorithm = SignedDataParser.getDigestAlgorithm(digestAlgorithm, digestEncryptionAlgorithm);
            byte[] signedattrs = null;
            try {
                ASN1Set signedattrSet = signerInfo.getAuthenticatedAttributes();
                if (signedattrSet != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
                    aos.writeObject((ASN1Encodable)signedattrSet);
                    signedattrs = baos.toByteArray();
                }
            }
            catch (Exception signedattrSet) {
                // empty catch block
            }
            boolean ret = false;
            Signature sig = null;
            if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                sig = Signature.getInstance(signAlgorithm, jceProvider);
            } else {
                sig = Signature.getInstance(signAlgorithm);
            }
            sig.initVerify(x509SigningCert.getPublicKey());
            if (signedattrs != null) {
                sig.update(signedattrs);
            } else {
                sig.update(inputData);
            }
            ret = sig.verify(digest);
            if (ret) {
                contentData = inputData;
            }
            return contentData;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{signAlgorithm}));
        }
        catch (InvalidKeyException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        catch (SignatureException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        catch (NoSuchProviderException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
    }

    public static byte[] getConetentData(SignedData data) throws CAMCryptoException {
        DEROctetString contents = (DEROctetString)data.getContentInfo().getContent();
        if (contents == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_detached_signature"));
        }
        byte[] contentData = contents.getOctets();
        return contentData;
    }

    private static String getDigestAlgorithm(String digestAlgorithmOID, String digestEncryptionAlgorithmOID) {
        String da = null;
        String dea = null;
        if (digestAlgorithmOID.equals("1.2.840.113549.2.5")) {
            da = "MD5";
        } else if (digestAlgorithmOID.equals("1.2.840.113549.2.2")) {
            da = "MD2";
        } else if (digestAlgorithmOID.equals("1.3.14.3.2.26")) {
            da = "SHA1";
        } else if (digestAlgorithmOID.equals("2.16.840.1.101.3.4.2.1")) {
            da = "SHA256";
        } else if (digestAlgorithmOID.equals("2.16.840.1.101.3.4.2.2")) {
            da = "SHA384";
        } else if (digestAlgorithmOID.equals("2.16.840.1.101.3.4.2.3")) {
            da = "SHA512";
        }
        if (digestEncryptionAlgorithmOID.equals("1.2.840.113549.1.1.1")) {
            dea = "RSA";
        } else if (digestEncryptionAlgorithmOID.equals("1.2.840.10040.4.1")) {
            dea = "DSA";
        }
        return da + "with" + dea;
    }

    private static X509Certificate[] buildX509CertChain(X509Certificate x509SigningCert, Map<Principal, X509Certificate> issurCertMap) {
        Vector<X509Certificate> certChain = new Vector<X509Certificate>();
        int i = 0;
        X509Certificate c = x509SigningCert;
        do {
            certChain.add(c);
            if (c.getSubjectDN().equals(c.getIssuerDN())) break;
            c = issurCertMap.get(c.getIssuerDN());
            ++i;
        } while (c != null);
        int certChainLength = certChain.size();
        X509Certificate[] x509CertChainArray = new X509Certificate[certChainLength];
        for (int j = 0; j < certChainLength; ++j) {
            x509CertChainArray[j] = (X509Certificate)certChain.get(j);
        }
        return x509CertChainArray;
    }
}

