/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.xml;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DefaultAdditionalInfoHandler;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CSKDigest;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.KeyExpiryChecker;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.objectpools.DocumentBuilderPool;
import com.cognos.accman.jcam.crypto.objectpools.PooledObject;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;

public class BaseTrustedSession
extends DefaultAdditionalInfoHandler {
    private byte[] currentCskDigest = CSKDigest.getInstance().getCurrentCSKDigest();
    private Mac currentCskMac = this.getMacGivenCSKDigest(this.currentCskDigest);
    protected int hmacLength = this.currentCskMac.getMacLength();

    protected BaseTrustedSession() throws CAMCryptoException {
    }

    protected void updateCSK() throws CAMCryptoException {
        byte[] up2date_currentCskDigest = null;
        try {
            KeyStoreReader.getCSKWithExpiryCheck();
            up2date_currentCskDigest = CSKDigest.getInstance().getCurrentCSKDigest();
        }
        catch (CAMCryptoException e) {
            new IPFAuditFunction("setMessageTrust", this).logExit(e);
            throw e;
        }
        if (!Arrays.equals(up2date_currentCskDigest, this.currentCskDigest)) {
            this.currentCskDigest = up2date_currentCskDigest;
            this.currentCskMac = this.getMacGivenCSKDigest(this.currentCskDigest);
        }
    }

    protected void validateIdentity() throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        if (!config.getUsingThirdPartyCA() && !config.isCAKeyPairValid()) {
            try {
                KeyExpiryChecker.checkForCAKeyExpiry();
            }
            catch (CAMCryptoException e) {
                IPFTraceFunction.trace("Error checking CA rollover.");
            }
        }
        if (!config.isIdentityKeyPairValid()) {
            if (!config.getUsingThirdPartyCA()) {
                try {
                    KeyExpiryChecker.checkForEncryptionKeyExpiry();
                }
                catch (CAMCryptoException e) {
                    IPFAuditFunction.trace("Error checking Encryption rollover.Ignore if this is the first install running configuration tool for first time");
                }
            } else {
                CAMCryptoException e = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_encryption_key_expired_using_third_party_ca"));
                e.printStackTrace();
                throw e;
            }
        }
    }

    protected Document domParse(byte[] document) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(document);
        PooledObject pooledDocBuilder = DocumentBuilderPool.getInstance().get();
        DocumentBuilder docBuilder = (DocumentBuilder)pooledDocBuilder.getObject();
        Document doc = docBuilder.parse(bais);
        pooledDocBuilder.release();
        return doc;
    }

    protected Mac getMacGivenCSKDigest(byte[] cskDigest) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        return CAMCryptoUtilities.getMacGivenCSKDigest(cskDigest, config.getHMACAlgorithm());
    }

    protected byte[] getCurrentCSKDigest() {
        return this.currentCskDigest;
    }

    protected Mac getCurrentCSKMac() {
        return this.currentCskMac;
    }

    protected Mac getCurrentCSKMac(String digestAlgorithm) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        String hmacAlgorithm = config.getHMACAlgorithm(digestAlgorithm);
        Mac mac = CAMCryptoUtilities.getMacGivenCSKDigest(this.currentCskDigest, hmacAlgorithm);
        return mac;
    }
}

