/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.utilities;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.cert.Certificate;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class JCAMEchoClient {
    CAMFactory cf = null;
    SSLSocket camClientSocket;
    ObjectOutputStream out;
    ObjectInputStream in;
    String message;
    String sendMsg = null;
    String recvMsg = null;
    String stopCall = "Bye";

    JCAMEchoClient() {
        try {
            this.cf = new CAMFactory("JCAMEchoClient");
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(URL url) {
        try {
            this.camClientSocket = (SSLSocket)this.cf.createSocket(url);
            System.out.println("\nConnected to: " + url.toString());
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        try {
            this.camClientSocket.startHandshake();
            SSLSession session = this.camClientSocket.getSession();
            Certificate[] servercerts = session.getPeerCertificates();
            this.out = new ObjectOutputStream(this.camClientSocket.getOutputStream());
            this.out.flush();
            this.in = new ObjectInputStream(this.camClientSocket.getInputStream());
            this.recvMsg = (String)this.in.readObject();
            while (!this.recvMsg.equals(this.stopCall)) {
                System.out.println("server > " + this.recvMsg);
                this.sendMsg = "Hello server";
                this.out.writeObject(this.sendMsg);
                this.out.flush();
                System.out.println("client > " + this.sendMsg);
                this.out.writeObject(this.stopCall);
                this.out.flush();
                System.out.println("client > " + this.stopCall);
                this.recvMsg = (String)this.in.readObject();
            }
            System.out.println("server > " + this.recvMsg);
            System.out.println("");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.in.close();
                this.out.close();
                this.camClientSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void start(URL url) {
        JCAMEchoClient client = new JCAMEchoClient();
        client.run(url);
    }
}

