/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.utilities;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.misc.CAMCSKKeyStore;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMKeyStore;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.accman.jcam.crypto.misc.KeyStoreManager;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.misc.KeyStoreWriter;
import com.cognos.accman.jcam.crypto.misc.KeysAlreadyExistException;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;

public class KeyStoreTools {
    CAMFactory cf = null;

    public KeyStoreTools() {
        try {
            this.cf = new CAMFactory("KeyStoreTools");
        }
        catch (CAMCryptoException e1) {
            e1.printStackTrace();
        }
    }

    public String getAllCSKKeysFromjCSKKeystore() throws Exception {
        StringBuffer cskKeys = new StringBuffer();
        Configuration config = Configuration.getInstance();
        String cskPassword = config.getCSKPassword();
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        KeyStore cskKeystore = ksManager.getCSKKeystore();
        Enumeration<String> cskEntries = cskKeystore.aliases();
        int i = 1;
        while (cskEntries.hasMoreElements()) {
            String alias = cskEntries.nextElement();
            if (!cskKeystore.isKeyEntry(alias)) continue;
            SecretKey key = (SecretKey)cskKeystore.getKey(alias, cskPassword.toCharArray());
            Date creationDate = cskKeystore.getCreationDate(alias);
            this.addCSKKeyEntry(cskKeys, config, i, alias, key, creationDate);
            ++i;
        }
        System.out.println("\n");
        return cskKeys.toString();
    }

    public String getAllCSKKeysFromCAMCSKKeystore() throws Exception {
        StringBuffer cskKeys = new StringBuffer();
        Configuration config = Configuration.getInstance();
        String cskFile = config.getCSKLocationForCPP();
        CAMCSKKeyStore camCSKKeyStore = new CAMCSKKeyStore();
        camCSKKeyStore.load(cskFile);
        Object aCSKString = null;
        List<String> aliases = camCSKKeyStore.getAllAliases();
        Iterator<String> iterator = aliases.iterator();
        int i = 1;
        while (iterator.hasNext()) {
            String alias = iterator.next();
            SecretKey key = camCSKKeyStore.getKey(alias);
            Date creationDate = camCSKKeyStore.getCreationDate(alias);
            this.addCSKKeyEntry(cskKeys, config, i, alias, key, creationDate);
            ++i;
        }
        return cskKeys.toString();
    }

    public String getCACertificates() throws Exception {
        Configuration config = Configuration.getInstance();
        CAMKeyStore caKeyStore = null;
        try {
            caKeyStore = new CAMKeyStore(config.getCAMKeystoreLocation(), config.getCAKeyPassword(), config.getCAFormat(), config.getAsymmKeystoreProviderName());
            caKeyStore.lock();
            caKeyStore.loadKeyStore();
        }
        catch (CAMCryptoException cce) {
            caKeyStore.unlock();
            caKeyStore = null;
            throw cce;
        }
        finally {
            if (caKeyStore != null) {
                caKeyStore.unlock();
            }
        }
        return this.getCertificatesString(caKeyStore);
    }

    public String getEncCertificates() throws Exception {
        String s = this.getCertFromKeystore("encryption");
        return s;
    }

    public String getSignCertificates() throws Exception {
        String s = this.getCertFromKeystore("encryption");
        return s;
    }

    public boolean checkCertificateTrusted(X509Certificate cert) throws Exception {
        try {
            KeyStoreReader.verifyCertificateIsTrusted(cert, true);
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int createNewKeystores(boolean overideCurrentKeyPair, boolean overwriteCurrentFiles) {
        try {
            CAMFactory cAMFactory = new CAMFactory("CNFG");
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        System.out.println("\n");
        if (!overwriteCurrentFiles) {
            Configuration config = Configuration.getInstance();
            try {
                File caStore = new File(config.getCAMKeystoreLocation());
                File encStore = new File(config.getCAMKeystoreLocation());
                File signStore = new File(config.getCAMKeystoreLocation());
                if (caStore.exists() && encStore.exists() && signStore.exists()) {
                    System.out.println("Key stores exist, not overwrite key stores.\n");
                    return 1;
                }
            }
            catch (CAMCryptoException e) {
                e.printStackTrace();
            }
        }
        try {
            KeyStoreWriter.createCAKeyPair(overideCurrentKeyPair);
        }
        catch (KeysAlreadyExistException config) {
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        System.out.println("CA key store is created successfully.");
        try {
            KeyStoreWriter.createKeyPairAndAddToKeystore("encryption");
        }
        catch (KeysAlreadyExistException e) {
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        System.out.println("CAM crypto key store is created successfully.");
        try {
            KeyStoreWriter.createNewCSK();
        }
        catch (KeysAlreadyExistException e) {
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        System.out.println("CSK key store is created successfully.");
        System.out.println("\n");
        return 1;
    }

    public void createNewCACertAndAddToKeystores() {
        try {
            CAMFactory cAMFactory = new CAMFactory("CNFG");
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        System.out.println("\n");
        X509Certificate cert = null;
        try {
            cert = KeyStoreWriter.createCAKeyPair(true);
        }
        catch (KeysAlreadyExistException keysAlreadyExistException) {
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        KeyStoreManager ksMgr = KeyStoreManager.getInstance();
        try {
            CAMKeyStore caKeystore = ksMgr.getCAKeystore("ca");
            caKeystore.addTrustedCert(cert);
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        System.out.println("new certificate is created and added to jCAKeystore.");
        System.out.println("\n");
    }

    private String getCertificatesString(CAMKeyStore keyStore) throws CAMCryptoException {
        StringBuffer caCerts = new StringBuffer();
        Certificate[] certArray = keyStore.getAllCertificates();
        for (int i = 0; i < certArray.length; ++i) {
            X509Certificate cert = (X509Certificate)certArray[i];
            String c = cert.toString();
            caCerts.append("Certificate #" + (i + 1));
            caCerts.append("\n***************************\n");
            caCerts.append(c);
            caCerts.append("\n***************************\n\n");
        }
        return caCerts.toString();
    }

    private String getCertFromKeystore(String alias) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        CAMKeyStore camKeyStore = null;
        try {
            camKeyStore = new CAMKeyStore(config.getCAMKeystoreLocation(), config.getCAKeyPassword(), config.getCAFormat(), config.getAsymmKeystoreProviderName());
            camKeyStore.lock();
            camKeyStore.loadKeyStore();
        }
        catch (CAMCryptoException cce) {
            camKeyStore.unlock();
            camKeyStore = null;
            throw cce;
        }
        finally {
            if (camKeyStore != null) {
                camKeyStore.unlock();
            }
        }
        X509Certificate encCert = (X509Certificate)camKeyStore.getCertificate(alias);
        StringBuffer certs = new StringBuffer();
        String c = encCert.toString();
        certs.append("\n***************************\n");
        certs.append(c);
        certs.append("\n***************************\n\n");
        String s = certs.toString();
        return s;
    }

    private void addCSKKeyEntry(StringBuffer cskKeys, IConfiguration config, int n, String alias, SecretKey key, Date cskCreationDate) throws CAMCryptoException {
        String algorithm = key.getAlgorithm();
        byte[] keyBytes = key.getEncoded();
        int keySize = keyBytes.length * 8;
        Date expiryDate = new Date(cskCreationDate.getTime() + config.getCSKLifetime() * 86400000L);
        String aCSKString = null;
        if (alias.compareTo("csk") == 0) {
            byte[] cskDigest = CAMCryptoUtilities.digestCSK(key);
            String cskAlias = new String(CryptoWrapper.encodeBase64(cskDigest));
            aCSKString = n + ": alias = " + alias + "(" + cskAlias + ")" + "; expiry date = " + expiryDate.toString() + "; algorithm = " + algorithm + "; key size = " + keySize;
        } else {
            aCSKString = n + ": alias = " + alias + "; expiry date = " + expiryDate.toString() + "; algorithm = " + algorithm + "; key size = " + keySize;
        }
        cskKeys.append(aCSKString + "\n");
    }
}

