/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.utilities;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class MobileEchoClient {
    static final String pkcs12File = "C:\\inhouse_aps_Certificates.p12";
    static String pkcs12FilePassword = "mobile2012apn";
    static final String host = "localhost";
    static final int port = 9302;
    CAMFactory cf = null;
    SSLSocket camClientSocket;
    ObjectOutputStream out;
    ObjectInputStream in;
    String message;
    String sendMsg = null;
    String recvMsg = null;
    String stopCall = "Bye";

    MobileEchoClient() {
        try {
            this.cf = new CAMFactory("MobileEchoClient");
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
    }

    void run() {
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(host);
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        try {
            this.camClientSocket = (SSLSocket)this.cf.createSocket(pkcs12File, pkcs12FilePassword, ia, 9302, true);
            System.out.println("\nConnected to: localhost:9302");
        }
        catch (CertificateExpiredException e) {
            e.printStackTrace();
        }
        catch (CertificateNotYetValidException e) {
            e.printStackTrace();
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        try {
            this.camClientSocket.startHandshake();
            SSLSession session = this.camClientSocket.getSession();
            this.out = new ObjectOutputStream(this.camClientSocket.getOutputStream());
            this.out.flush();
            this.in = new ObjectInputStream(this.camClientSocket.getInputStream());
            this.recvMsg = (String)this.in.readObject();
            while (!this.recvMsg.equals(this.stopCall)) {
                System.out.println("server > " + this.recvMsg);
                this.sendMsg = "Hello server";
                this.out.writeObject(this.sendMsg);
                this.out.flush();
                System.out.println("client > " + this.sendMsg);
                this.out.writeObject(this.stopCall);
                this.out.flush();
                System.out.println("client > " + this.stopCall);
                this.recvMsg = (String)this.in.readObject();
            }
            System.out.println("server > " + this.recvMsg);
            System.out.println("");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.in.close();
                this.out.close();
                this.camClientSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void start() {
        MobileEchoClient client = new MobileEchoClient();
        client.run();
    }
}

