/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.res;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageSet {
    private static final String bundleNameBase = "jcam_errors";
    private static Locale productLocale = null;
    private static boolean bSetServerLocale = false;
    private static boolean bSetJvmLocale = false;

    public static String getMessage(String id) {
        return MessageSet.getMessage(id, "");
    }

    public static String getMessage(String id, String locale) {
        String msg;
        Locale oLocale = null;
        if (locale.compareTo("") == 0) {
            if (productLocale == null) {
                String msg2 = MessageSet.localeFinder(id);
                return msg2;
            }
            oLocale = productLocale;
        } else {
            oLocale = CAMCryptoUtilities.getLocaleObject(locale);
        }
        try {
            msg = ResourceBundle.getBundle(bundleNameBase, oLocale).getString(id);
        }
        catch (MissingResourceException e) {
            msg = MessageSet.localeFinder(id);
        }
        return msg;
    }

    public static String getMessage(String id, String[] parameters) {
        String sb = MessageSet.getMessage(id);
        for (int i = 0; i < parameters.length; ++i) {
            String paramName = "{" + Integer.toString(i) + "}";
            int index = sb.indexOf(paramName);
            try {
                sb = sb.substring(0, index) + parameters[i] + sb.substring(index + paramName.length());
                continue;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static boolean setLocale(String locale) {
        productLocale = CAMCryptoUtilities.getLocaleObject(locale);
        return true;
    }

    public static boolean setLocale(Locale locale) {
        productLocale = locale;
        return true;
    }

    private static String localeFinder(String id) {
        Configuration config = null;
        String msg = null;
        String serverLocale = null;
        if (!bSetServerLocale) {
            bSetServerLocale = true;
            if (config == null) {
                config = Configuration.getInstance();
            }
            try {
                if (config != null && !config.getWeAreTheConfigTool() && (serverLocale = config.getServerLocale()) != null) {
                    MessageSet.setLocale(serverLocale);
                    try {
                        msg = ResourceBundle.getBundle(bundleNameBase, productLocale).getString(id);
                        return msg;
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
            }
            catch (CAMCryptoException e) {
                e.printStackTrace();
            }
        }
        if (!bSetJvmLocale) {
            bSetJvmLocale = true;
            Locale jvmLocale = Locale.getDefault();
            MessageSet.setLocale(jvmLocale);
            try {
                msg = ResourceBundle.getBundle(bundleNameBase, productLocale).getString(id);
                return msg;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        MessageSet.setLocale(Locale.US);
        msg = ResourceBundle.getBundle(bundleNameBase, Locale.US).getString(id);
        return msg;
    }
}

