/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.restful;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.soap.BridgeError;
import com.ibm.bi.soap.restful.CmRest;
import com.ibm.bi.soap.restful.FieldsQueryParam;
import com.ibm.bi.soap.restful.PathBuilder;
import com.ibm.bi.soap.services.BiBus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentManager {
    public static final String ETAG_PUBLIC_PREFIX = "41-";
    public static final String ETAG_PRIVATE_PREFIX = "42-";
    public static final String CACHE_VALIDATOR = "cacheValidator";
    private static final Logger logger = LoggerFactory.getLogger(ContentManager.class);
    private static final HashSet<String> NON_CACHEABLE_PROPS = new HashSet<String>(Arrays.asList("defaultOutputFormat"));
    protected HttpServletRequest servletRequest;
    protected BiBus biBus;

    public ContentManager(HttpServletRequest request, BiBus bus) {
        this.servletRequest = request;
        this.biBus = bus;
    }

    protected ContentManager() {
    }

    public JsonObject query(String path, JsonArray props, JsonObject options, boolean cache) throws Exception {
        boolean cachedQuery = cache ? this.arePropertiesCacheable(props) : false;
        return cachedQuery ? this.queryCached(path, props, options) : this.queryNoCache(path, props, options);
    }

    private boolean arePropertiesCacheable(JsonArray props) {
        for (Object prop : props) {
            if (!NON_CACHEABLE_PROPS.contains(prop)) continue;
            return false;
        }
        return true;
    }

    public JsonObject query(String path, FieldsQueryParam fields, boolean schemaInfo, boolean cache) throws Exception {
        return this.query(path, fields.getProperties(), this.buildQueryOptions(fields, schemaInfo), cache);
    }

    public JsonObject add(String parentPath, String type, JsonObject data, String updateAction) throws Exception {
        this.verifyType(data, type);
        JsonArray anArray = new JsonArray();
        anArray.add((Object)data);
        JsonArray objects = (JsonArray)this.biBus.contentManager.add(parentPath, (List)anArray, (Map)this.buildAddOptions(updateAction));
        return objects.getObject(0);
    }

    public JsonArray add(String parentPath, JsonArray objects, String updateAction) throws Exception {
        return (JsonArray)this.biBus.contentManager.add(parentPath, (List)objects, (Map)this.buildAddOptions(updateAction));
    }

    public String getActiveContentManager() throws Exception {
        return this.biBus.contentManager.getActiveContentManager();
    }

    public JsonObject update(String id, String type, JsonObject data) throws Exception {
        this.verifyType(data, type);
        data.put("searchPath", (Object)PathBuilder.fromId(id));
        JsonArray anArray = new JsonArray();
        anArray.add((Object)data);
        return ((JsonArray)this.biBus.contentManager.update((List)anArray, null)).getObject(0);
    }

    public JsonArray update(JsonArray objects) throws Exception {
        return (JsonArray)this.biBus.contentManager.update((List)objects, null);
    }

    public Long delete(String path, boolean recursive, boolean force) throws Exception {
        JsonObject options = new JsonObject();
        options.put("force", (Object)force);
        options.put("recursive", (Object)recursive);
        JsonArray objects = new JsonArray(new Object[]{path});
        return (Long)this.biBus.contentManager.delete((List)objects, (Map)options);
    }

    public Long delete(String id, JsonObject options) throws Exception {
        JsonArray objects = new JsonArray(new Object[]{PathBuilder.fromId(id)});
        return (Long)this.biBus.contentManager.delete((List)objects, (Map)options);
    }

    public Long delete(List<String> paths, boolean recursive, boolean force) throws Exception {
        JsonObject options = new JsonObject();
        options.put("force", (Object)force);
        options.put("recursive", (Object)recursive);
        return (Long)this.biBus.contentManager.delete(paths, (Map)options);
    }

    protected JsonObject buildQueryOptions(FieldsQueryParam fields, boolean schemaInfo) {
        if (fields.getRefProps() == null && !schemaInfo) {
            return null;
        }
        JsonObject result = new JsonObject();
        if (fields.getRefProps() != null) {
            result.put("refProps", (Object)fields.getRefProps());
        }
        if (schemaInfo) {
            result.put("schemaInfo", (Object)schemaInfo);
        }
        return result;
    }

    protected JsonObject buildAddOptions(String updateAction) {
        JsonObject options = null;
        if (updateAction != null) {
            options = new JsonObject();
            options.put("updateAction", (Object)updateAction);
        }
        return options;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void verifyType(JsonObject data, String type) {
        String dataType = data.getString("type");
        if (dataType == null) {
            if (type == null) throw new HttpException(400, new Message(BridgeError.MISSING_PROPERTY, (Object)"type"));
            data.put("type", (Object)type);
            return;
        } else {
            if (type == null || type.equals(dataType)) return;
            throw new HttpException(400, new Message(BridgeError.INVALID_PROPERTY_VALUE, (Object)"type", (Object)dataType));
        }
    }

    protected JsonObject queryNoCache(String path, JsonArray props, JsonObject options) throws Exception {
        JsonArray data = (JsonArray)this.biBus.contentManager.query(path, (List)props, null, (Map)options);
        JsonObject result = new JsonObject();
        result.put("objects", (Object)data);
        result.put(CACHE_VALIDATOR, null);
        return result;
    }

    protected JsonObject queryCached(String path, JsonArray props, JsonObject options) throws Exception {
        JsonObject result;
        JsonArray items = new JsonArray();
        String etag = this.getRequestEtag();
        String cacheValidator = this.revalidateEtag(path, etag);
        if (cacheValidator != null) {
            result = new JsonObject();
            result.put(CACHE_VALIDATOR, (Object)cacheValidator);
        } else {
            if (this.isEtagSupported(etag)) {
                etag = null;
            }
            Map queryRequest = this.biBus.contentManager.queryRequest(path, (List)props, null, (Map)options);
            JsonArray queries = new JsonArray();
            queries.add((Object)queryRequest);
            result = (JsonObject)this.biBus.contentManager.queryMultipleCache((List)queries, etag == null ? "" : etag);
            JsonArray replies = (JsonArray)result.remove((Object)"replies");
            if (replies != null) {
                for (Object reply : replies) {
                    items.addAll((Collection)((JsonObject)reply).getArray("queryResult"));
                }
            }
        }
        result.put("objects", (Object)items);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int validateETag(String path, String etag) {
        try (CmRest cmRest = new CmRest(this.servletRequest);){
            int n = cmRest.validateEtag(path, etag);
            return n;
        }
        catch (IOException e) {
            logger.warn("Error calling CM REST API, will not use fast Etag validation", (Throwable)e);
            return 205;
        }
    }

    protected String revalidateEtag(String path, String etag) {
        if (!this.isEtagSupported(etag)) {
            return null;
        }
        int status = this.validateETag(path, etag);
        String cacheValidator = null;
        if (status == 410) {
            cacheValidator = "GONE";
        } else if (status == 304) {
            cacheValidator = etag;
        } else if (status != 205) {
            logger.warn("validateETag returned unexpected result: " + status);
        }
        return cacheValidator;
    }

    private boolean isEtagSupported(String etag) {
        return etag.startsWith(ETAG_PRIVATE_PREFIX) || etag.startsWith(ETAG_PUBLIC_PREFIX);
    }

    protected String getRequestEtag() {
        String s = this.servletRequest.getHeader("If-None-Match");
        if (s == null) {
            return "";
        }
        if (s.charAt(0) == '\"' && s.length() > 2) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

