/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.restful;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.soap.BridgeError;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class FieldsQueryParam {
    private JsonArray properties = null;
    private JsonArray refProps = null;
    private final String delimsField = ",{}";
    private final String delimsPropertyRegex = "\\.";
    private final String delimsProperty = ".";

    public FieldsQueryParam(String queryString) throws HttpException {
        this(queryString, null);
    }

    public FieldsQueryParam(String queryString, String defaults) throws HttpException {
        String props = queryString == null || queryString.isEmpty() ? (defaults == null ? "defaultName" : defaults) : queryString;
        props = props + ",modificationTime,version,id";
        this.properties = new JsonArray();
        this.parse(props);
    }

    public JsonArray getProperties() {
        return this.properties;
    }

    public JsonArray getRefProps() {
        return this.refProps;
    }

    private void parse(String params) {
        Map<String, JsonArray> paramsMap = this.parseParams(params);
        this.translateMapToCmQueryOptions(paramsMap);
    }

    private void translateMapToCmQueryOptions(Map<String, JsonArray> paramsMap) {
        for (Map.Entry<String, JsonArray> entry : paramsMap.entrySet()) {
            this.properties.add((Object)entry.getKey());
            if (entry.getValue().isEmpty()) continue;
            if (this.refProps == null) {
                this.refProps = new JsonArray();
            }
            JsonObject newRefProp = new JsonObject();
            newRefProp.put("refPropName", (Object)entry.getKey());
            newRefProp.put("properties", (Object)entry.getValue());
            this.refProps.add((Object)newRefProp);
        }
    }

    private Map<String, JsonArray> parseParams(String params) {
        HashMap<String, JsonArray> paramsMap = new HashMap<String, JsonArray>();
        StringTokenizer st = new StringTokenizer(params, ",{}", true);
        String possibleTokenBeforeOpeningBracket = "";
        int bracketCounter = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.contentEquals(",")) continue;
            if (token.contentEquals("{")) {
                if (bracketCounter > 0) {
                    this.throwBadFormat(params);
                }
                ++bracketCounter;
                continue;
            }
            if (token.contentEquals("}")) {
                if (bracketCounter == 0) {
                    this.throwBadFormat(params);
                }
                --bracketCounter;
                continue;
            }
            String[] propArray = token.split("\\.");
            if (propArray.length == 2) {
                if (bracketCounter > 0 || propArray[0].isEmpty() || propArray[1].isEmpty()) {
                    this.throwBadFormat(params);
                    continue;
                }
                if (!paramsMap.containsKey(propArray[0])) {
                    paramsMap.put(propArray[0], new JsonArray());
                }
                ((JsonArray)paramsMap.get(propArray[0])).add((Object)propArray[1]);
                continue;
            }
            if (propArray.length == 1) {
                if (token.contains(".")) {
                    this.throwBadFormat(params);
                }
                if (bracketCounter > 0) {
                    ((JsonArray)paramsMap.get(possibleTokenBeforeOpeningBracket)).add((Object)propArray[0]);
                    continue;
                }
                possibleTokenBeforeOpeningBracket = token;
                if (paramsMap.containsKey(propArray[0])) continue;
                paramsMap.put(propArray[0], new JsonArray());
                continue;
            }
            this.throwBadFormat(params);
        }
        if (bracketCounter > 0) {
            this.throwBadFormat(params);
        }
        return paramsMap;
    }

    private void throwBadFormat(String value) {
        throw new HttpException(400, new Message(BridgeError.INVALID_QUERY_PARAMETER_VALUE, (Object)"fields", (Object)value));
    }
}

