/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.restful;

import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.soap.BridgeError;
import java.util.HashMap;

public class PathBuilder {
    private static final HashMap<String, String> aliases = new HashMap();
    StringBuilder buf = new StringBuilder();

    public static String fromId(String id) {
        return new PathBuilder().id(id).toString();
    }

    public PathBuilder camid(String value) {
        this.buf.append("CAMID(");
        this.quote(value);
        this.buf.append(")");
        return this;
    }

    public PathBuilder id(String id) {
        if (id.charAt(0) == '.') {
            String alias = aliases.get(id);
            if (alias == null) {
                throw new HttpException(400, new Message(BridgeError.INVALID_OBJECT_ID, (Object)id));
            }
            this.buf.append(alias);
        } else {
            this.buf.append("storeID(\"").append(id).append("\")");
        }
        return this;
    }

    public PathBuilder defaultOutput(String id) {
        this.buf.append("defaultOutput(storeID(\"").append(id).append("\"))");
        return this;
    }

    public PathBuilder children(String type) {
        this.buf.append('/').append(type == null ? "*" : type);
        return this;
    }

    public PathBuilder descendants(String type) {
        this.buf.append("/descendant::").append(type == null ? "*" : type);
        return this;
    }

    public PathBuilder name(String name) {
        return this.equalTo("@name", name);
    }

    public PathBuilder last() {
        this.buf.append("[last()]");
        return this;
    }

    public PathBuilder equalTo(String property, String value) {
        this.buf.append('[').append(property).append('=');
        this.quote(value);
        this.buf.append(']');
        return this;
    }

    public PathBuilder isNotNull(String prop) {
        this.buf.append("[not(isNull('").append(prop).append("'))]");
        return this;
    }

    public PathBuilder isNull(String prop) {
        this.buf.append("[isNull('").append(prop).append("')]");
        return this;
    }

    public PathBuilder oneOf(String property, String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String value : values) {
            this.buf.append(sep).append(property).append('=');
            this.quote(value);
            sep = " or ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder noneOf(String property, String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String value : values) {
            this.buf.append(sep).append(property).append("!=");
            this.quote(value);
            sep = " and ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder anyPermission(String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String permission : values) {
            this.buf.append(sep).append("permission('").append(permission).append("')");
            sep = " or ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder allPermissions(String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String permission : values) {
            this.buf.append(sep).append("permission('").append(permission).append("')");
            sep = " and ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder navigationFilter() {
        this.buf.append("[@shown='true']");
        this.anyPermission("read", "write", "execute", "traverse", "setPolicy");
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public int length() {
        return this.buf.length();
    }

    public void setLength(int len) {
        if (len > this.buf.length()) {
            throw new IllegalArgumentException("invalid length: " + len + " > " + this.buf.length());
        }
        this.buf.setLength(len);
    }

    private void quote(String value) {
        int n = value.indexOf(34);
        if (n == -1) {
            this.buf.append('\"').append(value).append('\"');
        } else if (value.indexOf(39) == -1) {
            this.buf.append('\'').append(value).append('\'');
        } else {
            this.buf.append('\"');
            int start = 0;
            while (n != -1) {
                this.buf.append(value.substring(start, n)).append('\"');
                start = n + 1;
                n = value.indexOf(34, start);
            }
            this.buf.append(value.substring(start)).append('\"');
        }
    }

    static {
        aliases.put(".public_folders", "/content");
        aliases.put(".my_folders", "~/folder");
        aliases.put(".library", "/catalog");
    }
}

