/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.restful;

import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.soap.BridgeError;
import com.ibm.bi.soap.restful.FieldsQueryParam;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public class QueryParams {
    private HttpServletRequest servletRequest;

    public QueryParams(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public Boolean getBoolean(String name, boolean defaultValue) {
        String value = this.servletRequest.getParameter(name);
        return value != null ? Boolean.valueOf(value) : Boolean.valueOf(defaultValue);
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public String getString(String name, String defaultValue) {
        String value = this.servletRequest.getParameter(name);
        return value == null ? defaultValue : value;
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public Long getLong(String name, Long defaultValue) {
        String value = this.servletRequest.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new HttpException(400, new Message(BridgeError.INVALID_QUERY_PARAMETER_VALUE, (Object)name, (Object)value));
        }
    }

    public String[] getStringArray(String name) {
        return this.getStringArray(name, null);
    }

    public String[] getStringArray(String name, String defaultValue) {
        String param = this.servletRequest.getParameter(name);
        if (param == null) {
            if (defaultValue == null) {
                return null;
            }
            param = defaultValue;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : param.split(",")) {
            result.add(s);
        }
        return result.toArray(new String[0]);
    }

    public FieldsQueryParam getFields(String defaultValue) {
        String value = this.servletRequest.getParameter("fields");
        if (value == null) {
            value = defaultValue;
        }
        return new FieldsQueryParam(value);
    }
}

