/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.ArrayType;
import com.ibm.bi.soap.schema.PrimitiveType;
import com.ibm.bi.soap.schema.Schema;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.xml.Namespace;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DeserializationContext {
    public static final Type UNKNOWN_TYPE = new PrimitiveType("unknown");
    private static final QName SOAPENC_ARRAY = new QName(Namespace.SOAPENC.getUri(), "Array");
    public final XMLStreamReader reader;
    public final TypeLibrary typeLibrary;
    public final JsonFactory json;
    public final String baseURL;
    public ArrayList<Object> stack;

    public DeserializationContext(XMLStreamReader xmlReader, TypeLibrary typeLibrary, JsonFactory jsonFactory, String baseURL) {
        this.reader = xmlReader;
        this.typeLibrary = typeLibrary;
        this.json = jsonFactory;
        this.baseURL = baseURL;
        this.stack = new ArrayList(16);
    }

    public Type getElementType() {
        Schema schema;
        String xsiType = this.reader.getAttributeValue(Namespace.XSI.getUri(), "type");
        QName typeQName = this.parseQName(xsiType, false);
        if (typeQName == null) {
            return null;
        }
        boolean isArray = false;
        if (typeQName.equals(SOAPENC_ARRAY)) {
            xsiType = this.reader.getAttributeValue(Namespace.SOAPENC.getUri(), "arrayType");
            typeQName = this.parseQName(xsiType, true);
            if (typeQName == null) {
                return null;
            }
            isArray = true;
        }
        if ((schema = this.typeLibrary.getSchemaByNamespace(typeQName.getNamespaceURI())) == null) {
            return UNKNOWN_TYPE;
        }
        String typeName = typeQName.getLocalPart();
        Type result = null;
        if (isArray) {
            result = schema.getType(typeName + "Array");
            if (result == null && (result = schema.getType(typeName)) != null) {
                ArrayType atype = new ArrayType(typeName + "Array");
                atype.setSchema(schema);
                atype.setItemType(result);
                result = atype;
            }
        } else {
            result = schema.getType(typeName);
        }
        return result == null ? UNKNOWN_TYPE : result;
    }

    public Type getElementType(Type expected) {
        Type type = this.getElementType();
        if (type == null) {
            return expected;
        }
        if (type != expected && !type.isSubclassOf(expected)) {
            return null;
        }
        return type;
    }

    private QName parseQName(String s, boolean isArray) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int separator = s.indexOf(58);
        if (separator == -1) {
            return null;
        }
        String prefix = s.substring(0, separator);
        s = s.substring(separator + 1);
        String ns = this.reader.getNamespaceURI(prefix);
        if (ns == null) {
            return null;
        }
        if (isArray) {
            separator = s.indexOf(91);
            if (separator == -1) {
                return null;
            }
            s = s.substring(0, separator);
        }
        return new QName(ns, s);
    }

    public boolean isXsiNil() {
        String value = this.reader.getAttributeValue(Namespace.XSI.getUri(), "nil");
        return value != null && (value.equals("1") || value.equals("true"));
    }

    public String getElementText() throws XMLStreamException {
        try {
            return this.reader.getElementText();
        }
        catch (XMLStreamException e) {
            if (this.reader.isStartElement()) {
                XmlStreamUtils.skipElement(this.reader);
                XmlStreamUtils.skipElement(this.reader);
                return null;
            }
            throw e;
        }
    }

    public int nextTag() throws XMLStreamException {
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            if (event != 1 && event != 2) continue;
            return event;
        }
        throw new XMLStreamException("unexpected end of document");
    }
}

