/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.soap.schema.Schema;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeLibrary;
import java.util.HashMap;
import java.util.Map;

public class Pluralizer {
    private Schema bus;
    private Type baseClass;
    private static HashMap<String, String> plurals = new HashMap();
    private static HashMap<String, String> singulars = new HashMap();

    public Pluralizer(TypeLibrary typeLib) {
        this.bus = typeLib.getSchemaByName("bus");
        this.baseClass = this.bus.getType("baseClass");
    }

    public String pluralize(Type type) {
        if (!type.isSubclassOf(this.baseClass)) {
            return null;
        }
        String name = type.getName();
        String singular = plurals.get(name);
        if (singular != null) {
            return singular;
        }
        if (name.charAt(name.length() - 1) == 'y') {
            return name.substring(0, name.length() - 1) + "ies";
        }
        return name + "s";
    }

    public Type singularize(String name) {
        String result = singulars.get(name);
        if (result == null) {
            if (name.endsWith("ies")) {
                result = name.substring(0, name.length() - 3) + 'y';
            } else if (name.charAt(name.length() - 1) == 's') {
                result = name.substring(0, name.length() - 1);
            } else {
                return null;
            }
        }
        return this.bus.getType(result);
    }

    static {
        plurals.put("analysis", "analyses");
        plurals.put("historyDetailRelatedReports", "historyDetailRelatedReports");
        plurals.put("historyDetailRequestArguments", "historyDetailRequestArguments");
        plurals.put("dataMovementTaskAlias", "dataMovementTaskAliases");
        plurals.put("nil", "nil");
        for (Map.Entry<String, String> entry : plurals.entrySet()) {
            singulars.put(entry.getValue(), entry.getKey());
        }
    }
}

