/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.xml.DefaultNamespace;
import com.ibm.bi.soap.xml.Namespace;
import java.util.Collection;
import java.util.HashMap;

public class Schema {
    private final Namespace ns;
    private HashMap<String, Type> types;

    public Schema(String name, String namespace) {
        this(new DefaultNamespace(namespace, name));
    }

    public Schema(Namespace ns) {
        this.ns = ns;
        this.types = new HashMap();
    }

    public String getName() {
        return this.ns.getPrefix();
    }

    public String getNamespaceURI() {
        return this.ns.getUri();
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    public Type getType(String name) {
        return this.types.get(name);
    }

    public Collection<Type> types() {
        return this.types.values();
    }

    public void addType(Type t) {
        String name = t.getName();
        Type old = this.types.put(name, t);
        if (old != null) {
            this.types.put(name, old);
            throw new IllegalStateException("Duplicate type: " + name);
        }
        t.setSchema(this);
    }
}

