/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.xml.Namespace;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SoapDeserializer {
    private static final QName SOAP_ENVELOPE = new QName(Namespace.SOAPENV.getUri(), "Envelope", "SOAP-ENV");
    private static final QName SOAP_HEADER = new QName(Namespace.SOAPENV.getUri(), "Header", "SOAP-ENV");
    private static final QName SOAP_BODY = new QName(Namespace.SOAPENV.getUri(), "Body", "SOAP-ENV");
    private static final QName SOAP_FAULT = new QName(Namespace.SOAPENV.getUri(), "Fault", "SOAP-ENV");
    private final TypeLibrary typeLib;
    private final JsonFactory json;
    private final String baseURL;

    public SoapDeserializer(TypeLibrary typeLib, JsonFactory jsonFactory, String baseURL) {
        this.typeLib = typeLib;
        this.json = jsonFactory;
        this.baseURL = baseURL;
    }

    public Object parse(Reader input, Type t) throws XMLStreamException {
        XMLStreamReader reader = XmlStreamUtils.getInputFactory().createXMLStreamReader(input);
        return this.parse(reader, t);
    }

    public Object parse(InputStream input, Type t) throws XMLStreamException {
        XMLStreamReader reader = XmlStreamUtils.getInputFactory().createXMLStreamReader(input, "utf-8");
        return this.parse(reader, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parse(XMLStreamReader reader, Type type) throws XMLStreamException {
        DeserializationContext dc = new DeserializationContext(reader, this.typeLib, this.json, this.baseURL);
        try {
            reader.nextTag();
            type = type != null ? dc.getElementType(type) : dc.getElementType();
            if (type == null) {
                throw new XMLStreamException("Unable to determine object type");
            }
            Object object = type.deserialize(dc);
            return object;
        }
        finally {
            XmlStreamUtils.closeReader(reader);
        }
    }

    public Map parseSOAPResponse(InputStream input, Type header, Method method, SoapFaultHandler faultHandler) throws XMLStreamException, SoapException {
        XMLStreamReader reader = XmlStreamUtils.getInputFactory().createXMLStreamReader(input, "utf-8");
        try {
            Map map = this.parseSOAPResponse(reader, header, method, faultHandler);
            return map;
        }
        catch (XMLStreamException e) {
            Throwable cause = e.getNestedException();
            if (cause instanceof SoapException) {
                throw (SoapException)cause;
            }
            throw e;
        }
        finally {
            XmlStreamUtils.closeReader(reader);
        }
    }

    private Map parseSOAPResponse(XMLStreamReader reader, Type header, Method m, SoapFaultHandler faultHandler) throws XMLStreamException, SoapException {
        DeserializationContext dc = new DeserializationContext(reader, this.typeLib, this.json, this.baseURL);
        reader.nextTag();
        this.expect(reader, SOAP_ENVELOPE);
        reader.nextTag();
        this.expect(reader, SOAP_HEADER);
        Map envelope = this.json.createObject();
        while (reader.nextTag() != 2) {
            if (dc.getElementType(header) != null) {
                envelope.put(this.json.createString("header"), header.deserialize(dc));
                continue;
            }
            XmlStreamUtils.skipElement(dc.reader);
        }
        reader.nextTag();
        this.expect(reader, SOAP_BODY);
        if (m.getName() == null) {
            XmlStreamUtils.skipElement(dc.reader);
        } else {
            reader.nextTag();
            if (reader.getName().equals(SOAP_FAULT)) {
                faultHandler.parseFault(dc);
            }
            while (reader.nextTag() != 2) {
                if (dc.getElementType(m.getReturnType()) != null) {
                    envelope.put(this.json.createString("body"), m.getReturnType().deserialize(dc));
                    continue;
                }
                XmlStreamUtils.skipElement(dc.reader);
            }
        }
        return envelope;
    }

    private void expect(XMLStreamReader reader, QName qname) throws XMLStreamException {
        if (!reader.getName().equals(qname)) {
            StringBuilder buf = new StringBuilder();
            buf.append(qname.getPrefix()).append(":").append(qname.getLocalPart()).append(" expected");
            throw new XMLStreamException(buf.toString());
        }
    }
}

