/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.Parameter;
import com.ibm.bi.soap.schema.SOAPWriter;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.MimeAttachment;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class SoapSerializer {
    private final TypeLibrary typeLib;
    private final JsonFactory jsonFactory;
    private boolean orderedProperties = true;
    private int cdataThreshold = Integer.MAX_VALUE;

    public void setCdataThreshold(int value) {
        this.cdataThreshold = value;
    }

    public void orderProperties(boolean value) {
        this.orderedProperties = value;
    }

    public SoapSerializer(TypeLibrary typeLib, JsonFactory jsonFactory) {
        this.typeLib = typeLib;
        this.jsonFactory = jsonFactory;
    }

    public void write(OutputStream os, String tag, Type type, Object value) {
        this.write(new SOAPWriter(os, "utf-8"), type, tag, value);
    }

    public void write(StringBuilder buf, String tag, Type type, Object value) {
        this.write(new SOAPWriter(buf), type, tag, value);
    }

    public String write(Type type, String tag, Object value) {
        StringBuilder buf = new StringBuilder();
        this.write(new SOAPWriter(buf), type, tag, value);
        return buf.toString();
    }

    public void write(Writer wrt, Type type, String tag, Object value) {
        this.write(new SOAPWriter(wrt), type, tag, value);
    }

    public void write(SOAPWriter wrt, Type type, String tag, Object value) {
        type.serialize(this.createContext(wrt), tag, value);
    }

    public List<MimeAttachment> writeSoapRequest(OutputStream os, Object header, Type headerType, Method m, Map args) {
        return this.writeSoapRequest(new SOAPWriter(os, "utf-8"), header, headerType, m, args);
    }

    private List<MimeAttachment> writeSoapRequest(SOAPWriter wrt, Object header, Type headerType, Method m, Map args) {
        SerializationContext sc = this.createContext(wrt);
        ((SOAPWriter)wrt.envelope()).addDefaultNamespaces(this.typeLib);
        wrt.header();
        if (header != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(headerType.getSchema().getNamespace().getPrefix()).append(':').append(headerType.getName());
            headerType.serialize(sc, buf.toString(), header);
        }
        wrt.end();
        wrt.body();
        if (m.getName() != null) {
            wrt.element(m.getNamespace(), m.getName());
            for (Parameter p : m.parameters()) {
                Object paramName = this.jsonFactory.createString(p.getName());
                if (!args.containsKey(paramName)) continue;
                p.serialize(sc, args.get(paramName));
            }
            wrt.end();
        }
        wrt.end();
        wrt.end();
        return sc.getAttachments();
    }

    private SerializationContext createContext(SOAPWriter wrt) {
        SerializationContext sc = new SerializationContext(this.typeLib, wrt, this.jsonFactory);
        sc.orderedProperties = this.orderedProperties;
        sc.cdataThreshold = this.cdataThreshold;
        return sc;
    }
}

