/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.soap.schema.AbstractType;
import com.ibm.bi.soap.schema.Property;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeHandler;
import com.ibm.bi.soap.schema.handlers.StructHandler;
import java.util.Collection;
import java.util.LinkedHashMap;

public class StructType
extends AbstractType {
    public static final TypeHandler DEFAULT_HANDLER = new StructHandler();
    protected LinkedHashMap<String, Property> properties = new LinkedHashMap();

    public StructType(String name) {
        this(name, DEFAULT_HANDLER);
    }

    public StructType(String name, TypeHandler handler) {
        super(name, handler);
    }

    public void addProperty(String name, Type type) {
        if (this.properties.containsKey(name)) {
            throw new IllegalStateException("Duplicate property name: " + name);
        }
        this.properties.put(name, new Property(name, type, this.properties.size()));
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<Property> properties() {
        return this.properties.values();
    }

    @Override
    public void setBaseType(Type t) {
        super.setBaseType(t);
        if (!this.properties.isEmpty()) {
            throw new IllegalStateException("Base type has to be set before properties are loaded");
        }
        this.properties.putAll(((StructType)this.base).properties);
    }
}

