/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.soap.schema.Pluralizer;
import com.ibm.bi.soap.schema.Schema;
import com.ibm.bi.soap.schema.UserCapabilitiesDecoder;
import java.util.Collection;
import java.util.HashMap;

public class TypeLibrary {
    private HashMap<String, Schema> byName = new HashMap();
    private HashMap<String, Schema> byNamespace = new HashMap();
    private String version;
    private Pluralizer pluralizer;
    private UserCapabilitiesDecoder capabilitiesDecoder;

    public TypeLibrary(String version) {
        this.version = version;
    }

    void setPluralizer(Pluralizer pluralizer) {
        this.pluralizer = pluralizer;
    }

    public Pluralizer getPluralizer() {
        return this.pluralizer;
    }

    public String getVersion() {
        return this.version;
    }

    public void addSchema(Schema schema) {
        String name = schema.getName();
        String ns = schema.getNamespaceURI();
        if (this.byName.containsKey(name)) {
            throw new IllegalStateException("Duplicate schema name: " + name);
        }
        if (this.byNamespace.containsKey(ns)) {
            throw new IllegalStateException("Duplicate schema URI: " + ns);
        }
        this.byName.put(name, schema);
        this.byNamespace.put(ns, schema);
    }

    public Schema getSchemaByName(String name) {
        return this.byName.get(name);
    }

    public Schema getSchemaByNamespace(String ns) {
        return this.byNamespace.get(ns);
    }

    public Collection<Schema> schemas() {
        return this.byName.values();
    }

    public UserCapabilitiesDecoder getCapabilitiesDecoder() {
        return this.capabilitiesDecoder;
    }

    public void setCapabilitiesDecoder(UserCapabilitiesDecoder decoder) {
        this.capabilitiesDecoder = decoder;
    }
}

