/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.soap.schema.ArrayType;
import com.ibm.bi.soap.schema.EnumType;
import com.ibm.bi.soap.schema.Pluralizer;
import com.ibm.bi.soap.schema.PrimitiveType;
import com.ibm.bi.soap.schema.Property;
import com.ibm.bi.soap.schema.PropertyHandler;
import com.ibm.bi.soap.schema.Schema;
import com.ibm.bi.soap.schema.StructType;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeHandler;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.schema.UserCapabilitiesDecoder;
import com.ibm.bi.soap.schema.XSD;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TypeLibraryLoader {
    private HashMap<String, TypeHandler> typeHandlers = null;
    private HashMap<String, PropertyHandler> propHandlers = null;
    private HashMap<String, Schema> schemasByPrefix;
    private HashMap<Schema, SchemaLoader> schemaLoaders;
    private HashMap<String, Integer> capabilitiesBits;

    public void addTypeHandler(String name, TypeHandler handler) {
        if (this.typeHandlers == null) {
            this.typeHandlers = new HashMap();
        }
        this.typeHandlers.put(name, handler);
    }

    public void addPropertyHandler(String name, PropertyHandler handler) {
        if (this.propHandlers == null) {
            this.propHandlers = new HashMap();
        }
        this.propHandlers.put(name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeLibrary load(File file) throws XMLStreamException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            TypeLibrary typeLibrary = this.load(fis);
            return typeLibrary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeLibrary load(InputStream is) throws XMLStreamException {
        XMLStreamReader reader = XmlStreamUtils.getInputFactory().createXMLStreamReader(is, "utf-8");
        try {
            TypeLibrary typeLibrary = this.load(reader);
            return typeLibrary;
        }
        finally {
            XmlStreamUtils.closeReader(reader);
        }
    }

    private void splitString(String s, char separator, String[] parts) {
        int i = s.indexOf(separator);
        parts[0] = s.substring(0, i);
        parts[1] = s.substring(i + 1);
    }

    private TypeLibrary load(XMLStreamReader reader) throws XMLStreamException {
        this.schemasByPrefix = new HashMap();
        this.schemaLoaders = new HashMap();
        reader.nextTag();
        String version = reader.getAttributeValue(null, "version");
        TypeLibrary typeLib = new TypeLibrary(version);
        while (reader.nextTag() != 2) {
            String tag = reader.getLocalName();
            if ("schema".equals(tag)) {
                SchemaLoader s = new SchemaLoader(reader);
                typeLib.addSchema(s.schema);
                this.schemaLoaders.put(s.schema, s);
                this.schemasByPrefix.put(s.schema.getNamespace().getPrefix(), s.schema);
                continue;
            }
            if (!"misc".equals(tag)) continue;
            this.parseMisc(reader, typeLib);
        }
        this.setTypeHandlers(typeLib);
        for (SchemaLoader schema : this.schemaLoaders.values()) {
            schema.resolve();
        }
        this.setPropertyHandlers(typeLib);
        typeLib.setPluralizer(new Pluralizer(typeLib));
        this.setCapabilitiesDecoder(typeLib);
        this.reset();
        return typeLib;
    }

    private void setTypeHandlers(TypeLibrary typeLib) {
        if (this.typeHandlers == null) {
            return;
        }
        String[] parts = new String[2];
        for (Map.Entry<String, TypeHandler> entry : this.typeHandlers.entrySet()) {
            this.splitString(entry.getKey(), ':', parts);
            Schema schema = typeLib.getSchemaByName(parts[0]);
            if (schema == null) {
                throw new IllegalStateException("Can't resolve type: " + entry.getKey());
            }
            Type type = schema.getType(parts[1]);
            if (type == null) {
                throw new IllegalStateException("Can't resolve type: " + entry.getKey());
            }
            type.setHandler(entry.getValue());
        }
    }

    private void setPropertyHandlers(TypeLibrary typeLib) {
        if (this.propHandlers == null) {
            return;
        }
        String[] typeParts = new String[2];
        String[] propParts = new String[2];
        for (Map.Entry<String, PropertyHandler> entry : this.propHandlers.entrySet()) {
            Type type;
            String propName = entry.getKey();
            this.splitString(propName, '.', propParts);
            this.splitString(propParts[0], ':', typeParts);
            Property prop = null;
            Schema schema = typeLib.getSchemaByName(typeParts[0]);
            if (schema != null && (type = schema.getType(typeParts[1])) != null && type instanceof StructType && (prop = ((StructType)type).getProperty(propParts[1])) != null) {
                prop.setHandler(entry.getValue());
                continue;
            }
            throw new IllegalStateException("Invalid property: " + propName);
        }
    }

    private void setCapabilitiesDecoder(TypeLibrary typeLib) {
        EnumType capabilitiesEnum = (EnumType)typeLib.getSchemaByName("bus").getType("userCapabilityEnum");
        if (capabilitiesEnum == null || this.capabilitiesBits == null || !capabilitiesEnum.items().containsAll(this.capabilitiesBits.keySet())) {
            throw new IllegalStateException("userCapabilitiesEnum definition doesn't match capability bit assignment");
        }
        typeLib.setCapabilitiesDecoder(new UserCapabilitiesDecoder(this.capabilitiesBits));
    }

    private void reset() {
        this.schemasByPrefix = null;
        this.schemaLoaders = null;
        this.capabilitiesBits = null;
    }

    private void parseMisc(XMLStreamReader reader, TypeLibrary typeLib) throws XMLStreamException {
        while (reader.nextTag() != 2) {
            if (reader.getLocalName().equals("enumeration")) {
                if (!reader.getAttributeValue(null, "name").equals("userCapabilityEnum")) continue;
                this.parseUserCapabilities(reader);
                continue;
            }
            XmlStreamUtils.skipElement(reader);
        }
    }

    private void parseUserCapabilities(XMLStreamReader reader) throws XMLStreamException {
        this.capabilitiesBits = new HashMap();
        while (reader.nextTag() != 2) {
            String value = reader.getAttributeValue(null, "value");
            String bitIndex = reader.getAttributeValue(null, "bitIndex");
            this.capabilitiesBits.put(value, new Integer(bitIndex));
            if (reader.nextTag() == 2) continue;
            throw new IllegalStateException("end of element expected");
        }
    }

    private class SchemaLoader {
        HashMap<String, BaseTypeLoader> types = new HashMap();
        Schema schema;
        String name;

        public SchemaLoader(XMLStreamReader reader) throws XMLStreamException {
            this.name = reader.getAttributeValue(null, "name");
            String prefix = reader.getAttributeValue(null, "prefix");
            if (this.name.equals("xsd")) {
                this.schema = XSD.instance;
            } else {
                String url = reader.getAttributeValue(null, "url");
                this.schema = new Schema(prefix, url);
            }
            while (reader.nextTag() != 2) {
                BaseTypeLoader type;
                switch (reader.getLocalName()) {
                    case "primitive": {
                        type = new PrimitiveLoader(reader);
                        break;
                    }
                    case "enum": {
                        type = new EnumLoader(reader);
                        break;
                    }
                    case "struct": {
                        type = new StructLoader(reader);
                        break;
                    }
                    case "array": {
                        type = new ArrayLoader(reader);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unexpected element");
                    }
                }
                this.types.put(type.name, type);
                this.schema.addType(type.type);
            }
        }

        void resolve() {
            for (BaseTypeLoader type : this.types.values()) {
                type.resolve();
            }
        }
    }

    private class StructLoader
    extends BaseTypeLoader {
        LinkedHashMap<String, String> props;

        StructLoader(XMLStreamReader reader) throws XMLStreamException {
            super(reader);
            this.props = new LinkedHashMap();
            while (reader.nextTag() != 2) {
                if (!reader.getLocalName().equals("prop")) {
                    throw new IllegalStateException("prop element expected");
                }
                String name = reader.getAttributeValue(null, "name");
                String type = reader.getAttributeValue(null, "type");
                this.props.put(name, type);
                if (reader.nextTag() == 2) continue;
                throw new IllegalStateException("no content expected");
            }
            if (this.props.isEmpty()) {
                this.props = null;
            }
            this.type = new StructType(this.name);
        }

        @Override
        void resolve() {
            super.resolve();
            if (this.props != null) {
                for (Map.Entry<String, String> prop : this.props.entrySet()) {
                    ((StructType)this.type).addProperty(prop.getKey(), this.resolveType(prop.getValue()));
                }
                this.props = null;
            }
        }
    }

    private class EnumLoader
    extends BaseTypeLoader {
        EnumLoader(XMLStreamReader reader) throws XMLStreamException {
            super(reader);
            EnumType etype = new EnumType(this.name);
            this.type = etype;
            while (reader.nextTag() != 2) {
                String name = reader.getAttributeValue(null, "name");
                etype.addItem(name);
                if (reader.nextTag() == 2) continue;
                throw new IllegalStateException("no content expected");
            }
        }
    }

    private class ArrayLoader
    extends BaseTypeLoader {
        String arrayType;

        ArrayLoader(XMLStreamReader reader) throws XMLStreamException {
            super(reader);
            this.arrayType = reader.getAttributeValue(null, "arrayType");
            if (reader.nextTag() != 2) {
                throw new IllegalStateException("no content expected");
            }
            this.type = new ArrayType(this.name);
        }

        @Override
        void resolve() {
            ((ArrayType)this.type).setItemType(this.resolveType(this.arrayType));
        }
    }

    private class PrimitiveLoader
    extends BaseTypeLoader {
        PrimitiveLoader(XMLStreamReader reader) throws XMLStreamException {
            super(reader);
            if (reader.nextTag() != 2) {
                throw new IllegalStateException("no content expected");
            }
            this.type = new PrimitiveType(this.name);
        }
    }

    private class BaseTypeLoader {
        String name;
        String base;
        Type type;

        BaseTypeLoader(XMLStreamReader reader) {
            this.name = reader.getAttributeValue(null, "name");
            this.base = reader.getAttributeValue(null, "base");
        }

        void resolve() {
            if (this.base != null) {
                Type baseType = this.resolveType(this.base);
                this.base = null;
                if (baseType.getSchema() != XSD.instance) {
                    SchemaLoader sl = (SchemaLoader)TypeLibraryLoader.this.schemaLoaders.get(baseType.getSchema());
                    BaseTypeLoader btl = sl.types.get(baseType.getName());
                    btl.resolve();
                }
                this.type.setBaseType(baseType);
            }
        }

        Type resolveType(String type) {
            String[] parts = new String[2];
            TypeLibraryLoader.this.splitString(type, ':', parts);
            Schema schema = (Schema)TypeLibraryLoader.this.schemasByPrefix.get(parts[0]);
            if (schema == null) {
                throw new IllegalStateException("Unresolved type reference: " + type);
            }
            Type result = schema.getType(parts[1]);
            if (result == null) {
                throw new IllegalStateException("Unresolved type reference: " + type);
            }
            return result;
        }
    }
}

