/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.soap.schema.ArrayType;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeHandler;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class ArrayHandler
implements TypeHandler {
    @Override
    public Object deserialize(DeserializationContext dc, Type type) throws XMLStreamException {
        if (dc.isXsiNil()) {
            XmlStreamUtils.skipElement(dc.reader);
            return dc.json.createNull();
        }
        ArrayType arrayType = (ArrayType)type;
        List result = dc.json.createArray();
        dc.stack.add(result);
        while (dc.nextTag() != 2) {
            Type t = dc.getElementType(arrayType.getItemType());
            if (t != null) {
                Object value = t.deserialize(dc);
                result.add(value);
                continue;
            }
            XmlStreamUtils.skipElement(dc.reader);
        }
        dc.stack.remove(dc.stack.size() - 1);
        return result;
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Type type, Object value) {
        ArrayType arrayType = (ArrayType)type;
        Type itemType = arrayType.getItemType();
        sc.writer.element(tag);
        if (sc.json.isNull(value)) {
            sc.writer.arrayType(itemType, 0);
            sc.writer.xsiNil();
        } else {
            sc.stack.add(value);
            List items = (List)value;
            sc.writer.arrayType(itemType, items.size());
            for (Object item : items) {
                itemType.serialize(sc, "item", item);
            }
            sc.stack.remove(sc.stack.size() - 1);
        }
        sc.writer.end();
    }
}

