/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.handlers.MetaHelper;
import com.ibm.bi.soap.schema.handlers.StructHandler;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class BasePropHandler
extends StructHandler {
    @Override
    public Object deserialize(DeserializationContext dc, Type type) throws XMLStreamException {
        Object jsValue;
        String tag = dc.reader.getLocalName();
        Object obj = super.deserialize(dc, type = dc.getElementType(type));
        if (dc.json.isNull(obj)) {
            return obj;
        }
        Map result = (Map)obj;
        Object jsSchemaInfo = dc.json.createString("schemaInfo");
        if (result.containsKey(jsSchemaInfo)) {
            Object schema = result.remove(jsSchemaInfo);
            if (!dc.stack.isEmpty()) {
                Map schemas = this.getSchemaInfos(dc);
                schemas.put(tag, schema);
            }
        }
        if (result.containsKey(jsValue = dc.json.createString("value"))) {
            return result.get(jsValue);
        }
        return dc.json.createNull();
    }

    private Map getSchemaInfos(DeserializationContext dc) {
        Object jsSchemaInfo = dc.json.createString("schemaInfo");
        Map parent = (Map)dc.stack.get(dc.stack.size() - 1);
        Map meta = new MetaHelper(dc.json).getMeta(parent, true);
        Map schemas = (Map)meta.get(jsSchemaInfo);
        if (schemas == null) {
            schemas = dc.json.createObject();
            meta.put(jsSchemaInfo, schemas);
        }
        return schemas;
    }

    private Map getSchemaInfo(SerializationContext sc, String propName) {
        Map schemaInfo;
        Object jsSchemaInfo = sc.json.createString("schemaInfo");
        Map parent = (Map)sc.stack.get(sc.stack.size() - 1);
        Map meta = new MetaHelper(sc.json).getMeta(parent, false);
        if (meta != null && (schemaInfo = (Map)meta.get(jsSchemaInfo)) != null) {
            Object jsTag = sc.json.createString(propName);
            return (Map)schemaInfo.get(jsTag);
        }
        return null;
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Type type, Object value) {
        Map schema = null;
        if (!sc.stack.isEmpty()) {
            schema = this.getSchemaInfo(sc, tag);
        }
        Map valueObj = sc.json.createObject();
        if (schema != null) {
            valueObj.put(sc.json.createString("schemaInfo"), schema);
        }
        valueObj.put(sc.json.createString("value"), value);
        super.serialize(sc, tag, type, valueObj);
    }
}

