/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Property;
import com.ibm.bi.soap.schema.SOAPWriter;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.StructType;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.handlers.StructHandler;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericStructHandler
extends StructHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GenericStructHandler.class);

    @Override
    public Object deserialize(DeserializationContext dc, Type type) throws XMLStreamException {
        Map obj = (Map)super.deserialize(dc, dc.getElementType(type));
        if (!dc.json.isNull((Object)obj)) {
            obj.put(dc.json.createString("type"), dc.json.createString(type.getName()));
        }
        return obj;
    }

    @Override
    protected void putProperty(DeserializationContext dc, Property prop, Map result) throws XMLStreamException {
        try {
            Object value = prop.deserialize(dc);
            if (value != null) {
                result.put(dc.json.createString(prop.getName()), value);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Type type, Object value) {
        if (sc.json.isNull(value)) {
            super.serialize(sc, tag, type, value);
            return;
        }
        Map jValue = (Map)value;
        Object otype = jValue.remove(sc.json.createString("type"));
        if (sc.json.isNull(otype)) {
            LOG.warn("null object type.");
            return;
        }
        String stype = sc.json.toString(otype);
        Type actualType = type.getSchema().getType(stype);
        if (actualType == null) {
            LOG.warn("Invalid type " + stype);
            return;
        }
        if (!actualType.isSubclassOf(type)) {
            LOG.warn("Invalid type " + stype);
            return;
        }
        StructType paramValueItemType = (StructType)actualType;
        ((SOAPWriter)sc.writer.element(tag)).type(actualType);
        sc.stack.add(value);
        this.writeProperties(sc, jValue, paramValueItemType);
        sc.stack.remove(sc.stack.size() - 1);
        sc.writer.end();
    }

    protected void writeProperties(SerializationContext sc, Map value, StructType optionType) {
        for (Property prop : optionType.properties()) {
            this.writeProperty(sc, value, optionType, prop.getName());
        }
    }

    protected void writeProperty(SerializationContext sc, Map value, StructType optionType, String propName) {
        Object propValue = value.get(sc.json.createString(propName));
        if (propValue != null) {
            Property prop = optionType.getProperty(propName);
            prop.serialize(sc, propValue);
        }
    }
}

