/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.handlers.ArrayHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class PermissionArrayHandler
extends ArrayHandler {
    private static HashMap<String, String> str2char = new HashMap();
    private static HashMap<Character, String> char2str = new HashMap();

    @Override
    public Object deserialize(DeserializationContext dc, Type type) throws XMLStreamException {
        Object obj = super.deserialize(dc, type);
        if (dc.json.isNull(obj)) {
            return obj;
        }
        Object jsName = dc.json.createString("name");
        Object jsAccess = dc.json.createString("access");
        StringBuilder buf = new StringBuilder();
        for (Map item : (List)obj) {
            Object jsPermission = item.get(jsName);
            if (dc.json.isNull(jsPermission)) continue;
            String svalue = str2char.get(dc.json.toString(jsPermission));
            String access = dc.json.toString(item.get(jsAccess));
            if ("deny".equals(access)) {
                svalue = svalue.toLowerCase();
            }
            buf.append(svalue);
        }
        return dc.json.createString(buf.toString());
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Type type, Object value) {
        if (sc.json.isString(value)) {
            List result = sc.json.createArray();
            char[] array = sc.json.toString(value).toCharArray();
            Object jsName = sc.json.createString("name");
            Object jsAccess = sc.json.createString("access");
            Object jsGrant = sc.json.createString("grant");
            Object jsDeny = sc.json.createString("deny");
            for (char ch : array) {
                Object access = jsGrant;
                if (Character.isLowerCase(ch)) {
                    ch = Character.toUpperCase(ch);
                    access = jsDeny;
                }
                Map obj = sc.json.createObject();
                obj.put(jsAccess, access);
                obj.put(jsName, sc.json.createString(char2str.get(Character.valueOf(ch))));
                result.add(obj);
            }
            value = result;
        }
        super.serialize(sc, tag, type, value);
    }

    static {
        str2char.put("read", "R");
        str2char.put("write", "W");
        str2char.put("execute", "X");
        str2char.put("traverse", "T");
        str2char.put("setPolicy", "P");
        for (Map.Entry<String, String> entry : str2char.entrySet()) {
            char2str.put(Character.valueOf(entry.getValue().charAt(0)), entry.getKey());
        }
    }
}

