/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.handlers.StringHandler;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class PropEnumHandler
extends StringHandler {
    private static final HashMap<String, String> soap2rest = new HashMap();
    private static final HashMap<String, String> rest2soap = new HashMap();

    public static String mapProperty(String name, boolean toRest) {
        return (toRest ? soap2rest : rest2soap).get(name);
    }

    public static String soap2rest(String value) {
        return soap2rest.get(value);
    }

    public static String rest2soap(String value) {
        return rest2soap.get(value);
    }

    @Override
    public Object deserialize(DeserializationContext dc, Type type) throws XMLStreamException {
        Object result = super.deserialize(dc, type);
        if (dc.json.isNull(result)) {
            return result;
        }
        String value = dc.json.toString(result);
        String mappedValue = soap2rest.get(value);
        if (mappedValue != null) {
            result = dc.json.createString(mappedValue);
        }
        return result;
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Type type, Object value) {
        String v;
        String mapped;
        if (!sc.json.isNull(value) && (mapped = rest2soap.get(v = sc.json.toString(value))) != null) {
            value = sc.json.createString(mapped);
        }
        super.serialize(sc, tag, type, value);
    }

    static {
        soap2rest.put("storeID", "id");
        soap2rest.put("type", "scheduleType");
        for (Map.Entry<String, String> entry : soap2rest.entrySet()) {
            rest2soap.put(entry.getValue(), entry.getKey());
        }
    }
}

