/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.schema.TypeLibraryLoader;
import com.ibm.bi.soap.schema.handlers.AncestorInfoHandler;
import com.ibm.bi.soap.schema.handlers.Base64BinaryHandler;
import com.ibm.bi.soap.schema.handlers.BaseClassHandler;
import com.ibm.bi.soap.schema.handlers.BasePropHandler;
import com.ibm.bi.soap.schema.handlers.BaseRoutingRuleHandler;
import com.ibm.bi.soap.schema.handlers.CamExceptionHandler;
import com.ibm.bi.soap.schema.handlers.GenericStructHandler;
import com.ibm.bi.soap.schema.handlers.JsonDeSerializingHandler;
import com.ibm.bi.soap.schema.handlers.MultilingualStringArrayHandler;
import com.ibm.bi.soap.schema.handlers.OptionHandler;
import com.ibm.bi.soap.schema.handlers.PropEnumHandler;
import com.ibm.bi.soap.schema.handlers.PropertyMappingHandler;
import com.ibm.bi.soap.services.ContentManager;
import com.ibm.bi.soap.services.DefaultSoapServicesFactory;
import com.ibm.bi.soap.services.DeliveryService;
import com.ibm.bi.soap.services.EventMgmtService;
import com.ibm.bi.soap.services.ISoapServicesFactory;
import com.ibm.bi.soap.services.MetadataService;
import com.ibm.bi.soap.services.MonitorService;
import com.ibm.bi.soap.services.QueryService;
import com.ibm.bi.soap.services.ReportService;
import com.ibm.bi.soap.services.SaCamService;
import com.ibm.bi.soap.services.SoapContext;
import com.ibm.bi.soap.services.SoapTransport;
import com.ibm.bi.soap.services.SoapTransportFactory;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiBus.class);
    private static TypeLibrary typeLib;
    private SoapTransport transport;
    private SoapContext context;
    private JsonFactory jsonFactory;
    private String baseURL;
    private ISoapServicesFactory servicesFactory;
    public final ContentManager contentManager;
    public final QueryService queryService;
    public final MetadataService metadataService;
    public final DeliveryService deliveryService;
    public final ReportService reportService;
    public final EventMgmtService eventMgmtService;
    public final MonitorService monitorService;
    public final SaCamService saCamService;

    private static void loadTypeLibrary() throws XMLStreamException {
        TypeLibraryLoader loader = new TypeLibraryLoader();
        loader.addTypeHandler("bus:baseClass", new BaseClassHandler());
        loader.addTypeHandler("bus:baseProp", new BasePropHandler());
        loader.addTypeHandler("bus:CAMException", new CamExceptionHandler());
        loader.addTypeHandler("bus:propEnum", new PropEnumHandler());
        loader.addTypeHandler("bus:multilingualStringArray", new MultilingualStringArrayHandler());
        loader.addTypeHandler("bus:multilingualTokenArray", new MultilingualStringArrayHandler());
        loader.addTypeHandler("bus:option", new OptionHandler());
        loader.addTypeHandler("bus:baseRoutingRule", new BaseRoutingRuleHandler());
        loader.addTypeHandler("bus:asynchSpecification", new GenericStructHandler());
        loader.addTypeHandler("bus:parmValueItem", new GenericStructHandler());
        loader.addTypeHandler("bus:promptOption", new PropertyMappingHandler("default", "isDefault"));
        loader.addTypeHandler("bus:ancestorInfo", new AncestorInfoHandler());
        loader.addTypeHandler("bus:memoPart", new GenericStructHandler());
        loader.addTypeHandler("bus:asynchDetail", new GenericStructHandler());
        loader.addTypeHandler("xsd:base64Binary", new Base64BinaryHandler());
        loader.addPropertyHandler("bus:baseClass.extensions", new JsonDeSerializingHandler());
        loader.addPropertyHandler("bus:output.dataDescriptor", new JsonDeSerializingHandler());
        loader.addPropertyHandler("bus:role.userProfileSettings", new JsonDeSerializingHandler());
        loader.addPropertyHandler("bus:session.userProfileSettings", new JsonDeSerializingHandler());
        loader.addPropertyHandler("bus:account.userProfileSettings", new JsonDeSerializingHandler());
        loader.addPropertyHandler("bus:dataSourceSchema.statusInfo", new JsonDeSerializingHandler());
        loader.addPropertyHandler("bus:dataSourceSchema.specification", new JsonDeSerializingHandler());
        loader.addPropertyHandler("bus:historyDetailMoserService.statusInfo", new JsonDeSerializingHandler());
        loader.addPropertyHandler("bus:historyDetailMoserService.specification", new JsonDeSerializingHandler());
        InputStream is = TypeLibraryLoader.class.getResourceAsStream("ombridge_types.xml");
        try {
            typeLib = loader.load(is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public BiBus(SoapContext context, String baseURL) throws Exception {
        this(SoapTransportFactory.getInstance().create(context != null ? context.getRequest() : null), context, baseURL, DefaultJsonFactory.instance);
    }

    public BiBus(SoapTransport transport, SoapContext context, String baseURL) {
        this(transport, context, baseURL, DefaultJsonFactory.instance);
    }

    public BiBus(SoapTransport transport, SoapContext context, String baseURL, JsonFactory jsonFactory) {
        this(transport, context, baseURL, jsonFactory, null);
    }

    public BiBus(SoapTransport transport, SoapContext context, String baseURL, JsonFactory jsonFactory, ISoapServicesFactory soapFactory) {
        this.transport = transport;
        this.context = context;
        this.jsonFactory = jsonFactory;
        if (baseURL.charAt(baseURL.length() - 1) != '/') {
            baseURL = baseURL + "/";
        }
        this.baseURL = baseURL;
        this.servicesFactory = soapFactory == null ? DefaultSoapServicesFactory.getInstance() : soapFactory;
        this.contentManager = this.servicesFactory.getContentManager(this);
        this.queryService = this.servicesFactory.getQueryService(this);
        this.metadataService = this.servicesFactory.getMetadataService(this);
        this.deliveryService = this.servicesFactory.getDeliveryService(this);
        this.reportService = this.servicesFactory.getReportService(this);
        this.saCamService = this.servicesFactory.getSaCamService(this);
        this.eventMgmtService = this.servicesFactory.getEventMgmtService(this);
        this.monitorService = this.servicesFactory.getMonitorService(this);
    }

    public SoapContext getContext() {
        return this.context;
    }

    public SoapTransport getTransport() {
        return this.transport;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public static TypeLibrary getTypeLibrary() {
        return typeLib;
    }

    public String getBaseUrl() {
        return this.baseURL;
    }

    static {
        try {
            BiBus.loadTypeLibrary();
        }
        catch (XMLStreamException e) {
            LOGGER.error(e.getLocalizedMessage());
        }
    }
}

