/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections4.iterators.IteratorEnumeration;

public class ClonedServletRequest
extends HttpServletRequestWrapper {
    private final String scheme;
    private final int port;
    private final int localPort;
    private final String remoteAddr;
    private final int remotePort;
    private final String remoteUser;
    private Cookie[] cookies;
    private final String contextPath;
    private String servletPath;
    Map<String, List<String>> headers = new HashMap<String, List<String>>();
    Map<String, Object> attributes = new HashMap<String, Object>();

    public ClonedServletRequest(HttpServletRequest request) {
        super(request);
        this.scheme = request.getScheme();
        this.port = request.getServerPort();
        this.localPort = request.getLocalPort();
        this.remoteAddr = request.getRemoteAddr();
        this.remotePort = request.getRemotePort();
        this.remoteUser = request.getRemoteUser();
        this.contextPath = request.getContextPath();
        this.servletPath = request.getServletPath();
        this.saveHeaders(request);
        this.saveCookies(request);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getServerPort() {
        return this.port;
    }

    public String getHeader(String name) {
        return this.headers.get(name) == null ? null : this.headers.get(name).get(0);
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public Enumeration<String> getHeaders(String name) {
        return new IteratorEnumeration(this.headers.get(name).iterator());
    }

    public Enumeration<String> getHeaderNames() {
        return new IteratorEnumeration(this.headers.keySet().iterator());
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    private void saveHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                ArrayList value = new ArrayList();
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    value.add(values.nextElement());
                }
                this.headers.put(name, value);
            }
        }
    }

    private void saveCookies(HttpServletRequest request) {
        Cookie[] originalCookies = request.getCookies();
        if (originalCookies == null || originalCookies.length == 0) {
            return;
        }
        this.cookies = ClonedServletRequest.cloneCookies(originalCookies);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteAddr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setCookies(Cookie[] newCookies) {
        if (newCookies == null) {
            return;
        }
        this.cookies = ClonedServletRequest.cloneCookies(newCookies);
        StringBuilder cookieHeaderValue = new StringBuilder();
        if (this.cookies != null && this.cookies.length > 0) {
            for (Cookie cookie : this.cookies) {
                if (cookie == null || cookie.getValue() == null || cookie.getValue().length() <= 0) continue;
                if (cookieHeaderValue.length() > 0) {
                    cookieHeaderValue.append("; ");
                }
                cookieHeaderValue.append(cookie.getName()).append("=").append(cookie.getValue());
            }
        }
        ArrayList<String> cookieValues = new ArrayList<String>();
        cookieValues.add(cookieHeaderValue.toString());
        this.headers.put("Cookie", cookieValues);
    }

    private static Cookie[] cloneCookies(Cookie[] toClone) {
        if (toClone == null || toClone.length == 0) {
            return null;
        }
        Cookie[] clonedCookies = new Cookie[toClone.length];
        for (int i = 0; i < toClone.length; ++i) {
            if (toClone[i] == null) continue;
            clonedCookies[i] = new Cookie(toClone[i].getName(), toClone[i].getValue());
        }
        return clonedCookies;
    }
}

