/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.ContentManager;
import com.ibm.bi.soap.services.DeliveryService;
import com.ibm.bi.soap.services.EventMgmtService;
import com.ibm.bi.soap.services.ISoapServicesFactory;
import com.ibm.bi.soap.services.MetadataService;
import com.ibm.bi.soap.services.MonitorService;
import com.ibm.bi.soap.services.QueryService;
import com.ibm.bi.soap.services.ReportService;
import com.ibm.bi.soap.services.SaCamService;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSoapServicesFactory
implements ISoapServicesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSoapServicesFactory.class);
    static final ISoapServicesFactory INSTANCE = new DefaultSoapServicesFactory();

    public static ISoapServicesFactory getInstance() {
        return INSTANCE;
    }

    protected DefaultSoapServicesFactory() {
        try {
            this.initServices();
        }
        catch (IOException | XMLStreamException ignore) {
            LOGGER.error(ignore.getMessage());
        }
    }

    protected void initServices() throws XMLStreamException, IOException {
        ContentManager.init(BiBus.getTypeLibrary());
        QueryService.init(BiBus.getTypeLibrary());
        MetadataService.init(BiBus.getTypeLibrary());
        DeliveryService.init(BiBus.getTypeLibrary());
        ReportService.init(BiBus.getTypeLibrary());
        SaCamService.init(BiBus.getTypeLibrary());
        EventMgmtService.init(BiBus.getTypeLibrary());
        MonitorService.init(BiBus.getTypeLibrary());
    }

    @Override
    public ContentManager getContentManager(BiBus biBus) {
        return new ContentManager(biBus);
    }

    @Override
    public QueryService getQueryService(BiBus biBus) {
        return new QueryService(biBus);
    }

    @Override
    public MetadataService getMetadataService(BiBus biBus) {
        return new MetadataService(biBus);
    }

    @Override
    public DeliveryService getDeliveryService(BiBus biBus) {
        return new DeliveryService(biBus);
    }

    @Override
    public ReportService getReportService(BiBus biBus) {
        return new ReportService(biBus);
    }

    @Override
    public SaCamService getSaCamService(BiBus biBus) {
        return new SaCamService(biBus);
    }

    @Override
    public EventMgmtService getEventMgmtService(BiBus biBus) {
        return new EventMgmtService(biBus);
    }

    @Override
    public MonitorService getMonitorService(BiBus biBus) {
        return new MonitorService(biBus);
    }
}

