/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.services.SoapService;
import com.ibm.bi.soap.xml.XMLUtils;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public abstract class EmsBaseService
extends SoapService
implements SoapFaultHandler {
    public EmsBaseService(BiBus bus) {
        super(bus);
    }

    protected List parseOptions(Map options) {
        JsonFactory json = this.bus.getJsonFactory();
        List opts = json.createArray();
        Map primaryWaitThreshold = json.createObject();
        primaryWaitThreshold.put(json.createString("type"), json.createString("asynchOptionInt"));
        primaryWaitThreshold.put(json.createString("name"), json.createString("primaryWaitThreshold"));
        primaryWaitThreshold.put(json.createString("value"), options.get("primaryWaitThreshold"));
        Map pagingOptionInt = json.createObject();
        pagingOptionInt.put(json.createString("type"), json.createString("pagingOptionInt"));
        pagingOptionInt.put(json.createString("name"), json.createString("maximumObjects"));
        pagingOptionInt.put(json.createString("value"), options.get("maximumObjects"));
        opts.add(primaryWaitThreshold);
        opts.add(pagingOptionInt);
        return opts;
    }

    protected Map createSecondaryRequest(Map primaryRequest, Map options) {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("conversation"), primaryRequest);
        List parameterValues = json.createArray();
        request.put(json.createString("parameterValues"), parameterValues);
        List opts = this.parseOptions(options);
        request.put(json.createString("options"), opts);
        return request;
    }

    protected Map createReleaseRequest(Map primaryRequest) {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("conversation"), primaryRequest);
        return request;
    }

    @Override
    public void parseFault(DeserializationContext dc) throws SoapException, XMLStreamException {
        String tagContent = null;
        StringBuilder textBuilder = new StringBuilder();
        Map detail = dc.json.createObject();
        List exceptionMessages = dc.json.createArray();
        String faultCode = null;
        String errorCode = null;
        while (dc.reader.hasNext()) {
            int event = dc.reader.next();
            switch (event) {
                case 4: {
                    tagContent = dc.reader.getText();
                    textBuilder.append(tagContent);
                    break;
                }
                case 2: {
                    if ("faultcode".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("faultcode"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                        faultCode = XMLUtils.collapseWhiteSpace(textBuilder.toString());
                    } else if ("faultstring".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("faultstring"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                    } else if ("severity".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("severity"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                    } else if ("errorCode".equals(dc.reader.getLocalName())) {
                        errorCode = XMLUtils.collapseWhiteSpace(textBuilder.toString());
                        detail.put(dc.json.createString("errorCode"), errorCode);
                    } else if ("messageString".equals(dc.reader.getLocalName())) {
                        if (exceptionMessages != null) {
                            exceptionMessages.add(XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                        }
                    } else if ("exception".equals(dc.reader.getLocalName())) {
                        detail.put(dc.json.createString("messages"), exceptionMessages);
                    }
                    textBuilder.setLength(0);
                    break;
                }
            }
        }
        if (faultCode != null && !"".equals(faultCode)) {
            if (faultCode.endsWith("Client")) {
                throw new SoapException(400, errorCode, detail);
            }
            throw new SoapException(500, errorCode, detail);
        }
        throw new SoapException(500, "UNEXPECTED", new JsonObject());
    }

    @Override
    protected SoapFaultHandler getSoapFaultHandler() {
        return this;
    }
}

