/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.platform.commons.http.util.HttpUtils;
import com.ibm.bi.soap.services.HttpEntityBuilder;
import com.ibm.bi.soap.services.MimeAttachment;
import com.ibm.bi.soap.services.SoapContext;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.services.SoapTransport;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransport
implements SoapTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTransport.class);
    private static final int SOAP_REQUEST_TIMEOUT_IN_MILLIS = 30000;
    private static final String MIME_BOUNDARY = "MIME_boundary";
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml; charset=UTF-8";
    private static final String CONTENT_TYPE_MULTIPART = "multipart/related; type=\"text/xml\"; boundary=MIME_boundary";
    private static final HttpEntityBuilder httpEntityBuilder = new HttpEntityBuilder();
    private final CloseableHttpClient httpClient;
    private final URI dispatcherUri;

    public HttpTransport(CloseableHttpClient httpClient, String uri) throws URISyntaxException {
        this.httpClient = httpClient;
        this.dispatcherUri = new URI(uri);
    }

    @Override
    public CloseableHttpResponse sendRequest(String soapAction, SoapContext context, InputStream is) throws Exception {
        return this.sendRequest(soapAction, context, is, 30000);
    }

    @Override
    public CloseableHttpResponse sendRequest(String soapAction, SoapContext context, InputStream is, int requestTimeout) throws Exception {
        HttpEntity httpEntity = httpEntityBuilder.createHttpEntity(is);
        HttpPost httpPost = this.createHttpPost(soapAction, context, httpEntity, CONTENT_TYPE_TEXT_XML);
        return this.sendRequest(httpPost, requestTimeout);
    }

    @Override
    public CloseableHttpResponse sendRequest(String soapAction, SoapContext context, InputStream is, List<MimeAttachment> attachments, int requestTimeout) throws Exception {
        if (attachments.isEmpty()) {
            return this.sendRequest(soapAction, context, is, requestTimeout);
        }
        HttpEntity httpEntity = httpEntityBuilder.createHttpEntity(is, attachments, MIME_BOUNDARY);
        HttpPost httpPost = this.createHttpPost(soapAction, context, httpEntity, CONTENT_TYPE_MULTIPART);
        return this.sendRequest(httpPost, requestTimeout);
    }

    private HttpPost createHttpPost(String soapAction, SoapContext context, HttpEntity httpEntity, String contentType) {
        HttpPost httpPost = new HttpPost(this.dispatcherUri);
        httpPost.addHeader("SOAPAction", soapAction);
        httpPost.addHeader("Content-Type", contentType);
        httpPost.setEntity(httpEntity);
        this.addRequestHeaders(httpPost, context);
        return httpPost;
    }

    void addRequestHeaders(HttpPost httpPost, SoapContext context) {
        for (Header header : context.getRequestHeaders()) {
            String name = header.getName();
            if (HttpUtils.hopByHopHeaders.containsHeader(name) || name.equalsIgnoreCase("Accept")) continue;
            httpPost.addHeader(header);
        }
    }

    private CloseableHttpResponse sendRequest(HttpPost httpPost, int requestTimeout) throws Exception {
        CloseableHttpResponse response;
        int statusCode;
        if (requestTimeout > 30000) {
            this.setRequestTimeout(httpPost, requestTimeout);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("POST {} Headers: {}", (Object)httpPost.getURI(), (Object)httpPost.getAllHeaders());
        }
        if ((statusCode = (response = this.httpClient.execute((HttpUriRequest)httpPost, (HttpContext)new BasicHttpContext())).getStatusLine().getStatusCode()) == 503) {
            throw new Exception("Service unavailable");
        }
        if (statusCode == 599) {
            throw new SoapException(statusCode, "camAuthSystemRecoverable", response.getEntity().getContent());
        }
        return response;
    }

    private void setRequestTimeout(HttpPost httpPost, int requestTimeout) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(requestTimeout).setSocketTimeout(requestTimeout).setConnectionRequestTimeout(requestTimeout).build();
        httpPost.setConfig(config);
    }
}

