/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.ServiceLoader;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.services.SoapService;
import com.ibm.bi.soap.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class MetadataService
extends SoapService {
    private static Method TEST_CONNECTION;
    private SoapFaultHandler faultHandler;

    static void init(TypeLibrary typeLib) throws XMLStreamException, IOException {
        HashMap<String, Method> methods;
        ServiceLoader serviceLoader = new ServiceLoader();
        try (InputStream is = MetadataService.class.getResourceAsStream("metadataService.xml");){
            methods = serviceLoader.load(typeLib, is);
        }
        TEST_CONNECTION = methods.get("testDataSourceConnection");
    }

    public MetadataService(BiBus bus) {
        super(bus);
    }

    public void testDataSourceConnection(String connectionStr, String credentialStr) throws Exception {
        this.faultHandler = new TestConnectionSoapFaultParser();
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("connectionString"), json.createString(connectionStr));
        request.put(json.createString("credentials"), json.createString(credentialStr));
        this.invoke(TEST_CONNECTION, request);
    }

    @Override
    protected SoapFaultHandler getSoapFaultHandler() {
        return this.faultHandler;
    }

    static class TestConnectionSoapFaultParser
    implements SoapFaultHandler {
        TestConnectionSoapFaultParser() {
        }

        @Override
        public void parseFault(DeserializationContext dc) throws XMLStreamException, SoapException {
            String tagContent = null;
            StringBuilder textBuilder = new StringBuilder();
            Map detail = dc.json.createObject();
            List exceptionMessages = dc.json.createArray();
            String faultCode = null;
            while (dc.reader.hasNext()) {
                int event = dc.reader.next();
                switch (event) {
                    case 4: {
                        tagContent = dc.reader.getText();
                        textBuilder.append(tagContent);
                        break;
                    }
                    case 2: {
                        if ("faultcode".equals(dc.reader.getLocalName())) {
                            detail.put(dc.json.createString("faultcode"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                        } else if ("faultstring".equals(dc.reader.getLocalName())) {
                            detail.put(dc.json.createString("faultstring"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                        } else if ("severity".equals(dc.reader.getLocalName())) {
                            detail.put(dc.json.createString("severity"), XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                        } else if ("errorCode".equals(dc.reader.getLocalName())) {
                            faultCode = XMLUtils.collapseWhiteSpace(textBuilder.toString());
                            detail.put(dc.json.createString("errorCode"), faultCode);
                        } else if ("messageString".equals(dc.reader.getLocalName())) {
                            if (exceptionMessages != null) {
                                exceptionMessages.add(XMLUtils.collapseWhiteSpace(textBuilder.toString()));
                            }
                        } else if ("exception".equals(dc.reader.getLocalName())) {
                            detail.put(dc.json.createString("messages"), exceptionMessages);
                        }
                        textBuilder.setLength(0);
                        break;
                    }
                }
            }
            if (faultCode != null && !"".equals(faultCode)) {
                throw new SoapException(400, faultCode, detail);
            }
        }
    }
}

