/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.ServiceLoader;
import com.ibm.bi.soap.services.SoapService;
import com.ibm.bi.soap.services.TestConnectionFaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class QueryService
extends SoapService {
    protected static Method TEST_CONNECTION;
    protected static Method TEST_CONNECTION_WITH_INFO;
    protected static Method MOSER_COMMAND;
    private SoapFaultHandler faultHandler = new TestConnectionFaultHandler();

    static void init(TypeLibrary typeLib) throws XMLStreamException, IOException {
        HashMap<String, Method> methods;
        ServiceLoader serviceLoader = new ServiceLoader();
        try (InputStream is = QueryService.class.getResourceAsStream("queryService.xml");){
            methods = serviceLoader.load(typeLib, is);
        }
        TEST_CONNECTION = methods.get("testDataSourceConnection");
        TEST_CONNECTION_WITH_INFO = methods.get("testDataSourceConnectionWithInfo");
        MOSER_COMMAND = methods.get("moserCommand");
    }

    public QueryService(BiBus bus) {
        super(bus);
    }

    public void testDataSourceConnection(String connectionStr, String credentialStr, String apiToken) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("connectionString"), json.createString(connectionStr));
        request.put(json.createString("credentials"), json.createString(credentialStr));
        if (apiToken != null) {
            request.put(json.createString("apiToken"), json.createString(apiToken));
        }
        this.invoke(TEST_CONNECTION, request);
    }

    public List testDataSourceConnectionWithInfo(String connectionStr, String credentialStr, String apiToken) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        request.put(json.createString("connectionString"), json.createString(connectionStr));
        request.put(json.createString("credentials"), json.createString(credentialStr));
        if (apiToken != null) {
            request.put(json.createString("apiToken"), json.createString(apiToken));
        }
        return (List)this.invoke(TEST_CONNECTION_WITH_INFO, request);
    }

    public List moserCommand(Map<String, String> params) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map request = json.createObject();
        List function = json.createArray();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            Map item = json.createObject();
            item.put(json.createString("name"), json.createString(entry.getKey()));
            item.put(json.createString("value"), json.createString(entry.getValue()));
            function.add(item);
        }
        request.put(json.createString("moserFunction"), function);
        List parameterValues = json.createArray();
        request.put(json.createString("parameterValues"), parameterValues);
        return (List)this.invoke(MOSER_COMMAND, request);
    }

    @Override
    protected SoapFaultHandler getSoapFaultHandler() {
        return this.faultHandler;
    }
}

