/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.SoapFaultHandler;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.ServiceLoader;
import com.ibm.bi.soap.services.SoapException;
import com.ibm.bi.soap.services.SoapService;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class SaCamService
extends SoapService
implements SoapFaultHandler {
    static Method GET_IDENTITY;
    private static Method TERMINATE_SESSIONS;
    private static Method SELECT_TENANTS;

    public SaCamService(BiBus bus) {
        super(bus);
    }

    static void init(TypeLibrary typeLib) throws XMLStreamException, IOException {
        ServiceLoader serviceLoader = new ServiceLoader();
        try (InputStream is = SaCamService.class.getResourceAsStream("sacamService.xml");){
            HashMap<String, Method> methods = serviceLoader.load(typeLib, is);
            GET_IDENTITY = methods.get("getIdentity");
            TERMINATE_SESSIONS = methods.get("terminateSessions");
            SELECT_TENANTS = methods.get("selectTenants");
        }
    }

    public Object getIdentity() throws Exception {
        return this.invoke(GET_IDENTITY, null);
    }

    public Object terminateSessions(String search) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("search"), json.createString(search));
        return this.invoke(TERMINATE_SESSIONS, obj);
    }

    public void selectTenants(String writeTenantID, String readTenantID) throws Exception {
        JsonFactory json = this.bus.getJsonFactory();
        Map obj = json.createObject();
        obj.put(json.createString("writeTenantID"), json.createString(writeTenantID));
        obj.put(json.createString("readTenantID"), json.createString(readTenantID));
        this.invoke(SELECT_TENANTS, obj);
    }

    @Override
    protected SoapFaultHandler getSoapFaultHandler() {
        return this;
    }

    @Override
    public void parseFault(DeserializationContext dc) throws SoapException, XMLStreamException {
        Type camException = dc.typeLibrary.getSchemaByName("bus").getType("CAMException");
        while (dc.reader.nextTag() != 2) {
            if (dc.reader.getLocalName().equals("detail")) {
                while (dc.reader.nextTag() != 2) {
                    if (dc.reader.getLocalName().equals("exception")) {
                        camException.deserialize(dc);
                        continue;
                    }
                    XmlStreamUtils.skipElement(dc.reader);
                }
                continue;
            }
            XmlStreamUtils.skipElement(dc.reader);
        }
    }
}

