/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.platform.commons.http.BaseHttpClientConfig;
import com.ibm.bi.soap.services.CAMCookie;
import com.ibm.bi.soap.services.ClonedServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapContext
extends BaseHttpClientConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapContext.class);
    private static final String DEFAULT_COOKIE_PATH = "/";
    private static final String DEFAULT_COOKIE_DOMAIN = null;
    protected NewCookie[] setCookies;
    protected JsonFactory json;
    private final List formFieldVars;
    protected Map<String, String> enviromentVars = new HashMap<String, String>();
    protected HttpServletRequest request;
    protected Map<String, String> userPreferenceVars = new HashMap<String, String>();
    private Map soapHeader = null;

    public SoapContext(HttpServletRequest request) {
        this(request, DefaultJsonFactory.instance);
    }

    public SoapContext(HttpServletRequest request, JsonFactory jsonFactory) {
        this.initCookies(request);
        this.request = new ClonedServletRequest(request);
        this.json = jsonFactory;
        this.formFieldVars = this.json.createArray();
        this.setRequestContext();
        this.prePopulateRequestHeaders(request);
        this.setTransactionCookie();
    }

    protected void setRequestContext() {
        this.request.setAttribute(SoapContext.class.getName(), (Object)this);
    }

    public byte[] setMessageTrust(byte[] request) {
        return request;
    }

    public boolean isTrusted() {
        return false;
    }

    public static final SoapContext getRequestInstance(HttpServletRequest request) {
        return (SoapContext)((Object)request.getAttribute(SoapContext.class.getName()));
    }

    public Response.ResponseBuilder saveState(Response.ResponseBuilder builder) {
        if (!this.isTrusted() && this.setCookies != null) {
            return builder.cookie(this.setCookies);
        }
        return builder;
    }

    public void addFormFieldVar(String name, String value) {
        this.formFieldVars.add(this.createHeaderArrayEntry(name, value));
    }

    public void addEnviromentVar(String name, String value) {
        if (value == null) {
            this.enviromentVars.remove(name);
        } else {
            this.enviromentVars.put(name, value);
        }
    }

    public void setRoutingServerGroup(String value) {
        Map bibusHeader = (Map)this.getSoapHeader();
        if (value != null) {
            Map routing = this.json.createObject();
            routing.put(this.json.createString("routingServerGroup"), value);
            bibusHeader.put(this.json.createString("routing"), routing);
        } else {
            bibusHeader.remove(this.json.createString("routing"));
        }
    }

    public Object getSoapHeader() {
        if (this.soapHeader == null) {
            this.soapHeader = this.createDefaultHeader();
        }
        return this.soapHeader;
    }

    public void setSecurityBlobInSoapHeader(String securityBlob) {
        Map header = (Map)this.getSoapHeader();
        Map cam = (Map)header.get(this.json.createString("CAM"));
        cam.put(this.json.createString("securityBlob"), securityBlob);
    }

    private Map createDefaultHeader() {
        LOGGER.trace("start createDefaultHeader");
        Map hdrSession = this.json.createObject();
        Map bibusHeader = this.json.createObject();
        bibusHeader.put(this.json.createString("hdrSession"), hdrSession);
        bibusHeader.put(this.json.createString("CAM"), this.createCamSection());
        if (!this.userPreferenceVars.isEmpty()) {
            bibusHeader.put(this.json.createString("userPreferenceVars"), this.createUserPreferenceVars());
        }
        hdrSession.put(this.json.createString("formFieldVars"), this.formFieldVars);
        hdrSession.put(this.json.createString("environmentVars"), this.createEnvVarSection());
        LOGGER.trace("end createDefaultHeader");
        return bibusHeader;
    }

    protected Object createCamSection() {
        Map result = this.json.createObject();
        if (this.isTrusted()) {
            String campassport;
            String usersessionid = this.getCookie("usersessionid");
            if (usersessionid != null) {
                result.put("userSessionID", usersessionid);
            }
            if (StringUtils.isNotBlank((String)(campassport = this.getCookie("cam_passport")))) {
                Map passport = this.json.createObject();
                passport.put("id", this.decodeCAMPassport(campassport));
                result.put("CAMPassport", passport);
            }
        }
        return result;
    }

    public void addUserPreferenceVars(String name, String value) {
        if (value == null) {
            this.userPreferenceVars.remove(name);
        } else {
            this.userPreferenceVars.put(name, value);
        }
    }

    private List createUserPreferenceVars() {
        List result = this.json.createArray();
        for (Map.Entry<String, String> userPreference : this.userPreferenceVars.entrySet()) {
            result.add(this.createHeaderArrayEntry(userPreference.getKey(), userPreference.getValue()));
        }
        return result;
    }

    private Map<Object, Object> createHeaderArrayEntry(String name, String value) {
        Map entry = this.json.createObject();
        entry.put(this.json.createString("name"), this.json.createString(name));
        entry.put(this.json.createString("value"), this.json.createString(value));
        return entry;
    }

    private List createEnvVarSection() {
        List result = this.json.createArray();
        result.add(this.createHeaderArrayEntry("REMOTE_ADDR", this.request.getRemoteAddr()));
        for (Map.Entry<String, String> enviromentVar : this.enviromentVars.entrySet()) {
            result.add(this.createHeaderArrayEntry(enviromentVar.getKey(), enviromentVar.getValue()));
        }
        return result;
    }

    private String decodeCAMPassport(String data) {
        return CAMCookie.createCookie(data).getPassportID();
    }

    private String getCookie(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cc : cookies) {
            if (!cc.getName().equalsIgnoreCase(name)) continue;
            return cc.getValue();
        }
        return null;
    }

    public void updateFromResponse(Object obj) {
        LOGGER.trace("start updateFromResponse");
        Map bibusHeader = (Map)obj;
        this.setCookies = this.parseCookies(bibusHeader);
        LOGGER.trace("end updateFromResponse");
    }

    public void resetSoapHeader() {
        this.soapHeader = null;
    }

    NewCookie[] parseCookies(Map bibusHeader) {
        Map hdrSession = (Map)bibusHeader.get(this.json.createString("hdrSession"));
        if (this.json.isNull((Object)hdrSession)) {
            LOGGER.trace("hdrSession null");
            return null;
        }
        List setCookieVars = (List)hdrSession.get(this.json.createString("setCookieVars"));
        if (this.json.isNull((Object)setCookieVars)) {
            LOGGER.trace("setCookieVars null");
            return null;
        }
        LOGGER.trace("found " + setCookieVars.size() + " cookies");
        ArrayList<NewCookie> cookies = new ArrayList<NewCookie>();
        for (Object object : setCookieVars) {
            Map setCookieVar = (Map)object;
            if (this.json.isNull((Object)setCookieVar)) continue;
            String name = null;
            String value = null;
            String domain = DEFAULT_COOKIE_DOMAIN;
            String comment = null;
            String path = DEFAULT_COOKIE_PATH;
            int maxAge = -1;
            boolean secure = false;
            Object jsonCookieAttribute = setCookieVar.get(this.json.createString("name"));
            if (!this.json.isNull(jsonCookieAttribute)) {
                name = this.json.toString(jsonCookieAttribute);
            }
            if (!this.json.isNull(jsonCookieAttribute = setCookieVar.get(this.json.createString("value")))) {
                value = this.json.toString(jsonCookieAttribute);
            }
            if (name == null && value != null) {
                LOGGER.trace("Ignoring cookie. name is missing, value was: " + value);
                continue;
            }
            if (name != null && value == null) {
                LOGGER.trace("Ignoring cookie. value is missing, name was: " + name);
                continue;
            }
            if (name == null && value == null) {
                LOGGER.trace("ignoring cookie. name and value are missing");
                continue;
            }
            jsonCookieAttribute = setCookieVar.get(this.json.createString("domain"));
            if (!this.json.isNull(jsonCookieAttribute)) {
                domain = this.json.toString(jsonCookieAttribute);
            }
            if (!this.json.isNull(jsonCookieAttribute = setCookieVar.get(this.json.createString("path")))) {
                path = this.json.toString(jsonCookieAttribute);
            }
            if (!this.json.isNull(jsonCookieAttribute = setCookieVar.get(this.json.createString("maxAge")))) {
                maxAge = this.mapCognosMaxAgeToBrowserMaxAge((int)this.json.toLong(jsonCookieAttribute));
            }
            if (!this.json.isNull(jsonCookieAttribute = setCookieVar.get(this.json.createString("secure")))) {
                secure = this.json.toBoolean(jsonCookieAttribute);
            }
            NewCookie newCookie = new NewCookie(name, value, path, domain, comment, maxAge, secure);
            LOGGER.trace("created cookie: " + newCookie.toString());
            cookies.add(newCookie);
        }
        return cookies.toArray(new NewCookie[0]);
    }

    int mapCognosMaxAgeToBrowserMaxAge(int cognosValue) {
        if (cognosValue < 0) {
            return 0;
        }
        if (cognosValue == 0) {
            return -1;
        }
        return cognosValue;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }
}

